/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.server.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Set;
import org.apache.mina.core.filterchain.DefaultIoFilterChainBuilder;
import org.apache.mina.core.service.IoAcceptor;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.handler.multiton.SingleSessionIoHandlerDelegate;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.core.net.ConnectionHelper;
import org.eclipse.scada.core.server.common.NetworkHelper;
import org.eclipse.scada.net.mina.SocketImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server {
    private static final Logger logger = LoggerFactory.getLogger(Server.class);
    private IoAcceptor acceptor;
    private final ConnectionInformation connectionInformation;

    public Server(ConnectionInformation connectionInformation) {
        this.connectionInformation = connectionInformation;
    }

    public Set<ConnectionInformation> start(SingleSessionIoHandlerDelegate ioHandler) throws IOException {
        this.acceptor = this.createAcceptor((IoHandler)ioHandler);
        return NetworkHelper.getLocalInterfaces((IoAcceptor)this.acceptor, (ConnectionInformation)this.connectionInformation);
    }

    private IoAcceptor createAcceptor(IoHandler ioHandler) throws IOException {
        IoAcceptor acceptor = null;
        SocketImpl socketImpl = SocketImpl.fromName((String)((String)this.connectionInformation.getProperties().get("socketImpl")));
        acceptor = socketImpl.createAcceptor();
        ConnectionHelper.setupFilterChain((ConnectionInformation)this.connectionInformation, (DefaultIoFilterChainBuilder)acceptor.getFilterChain(), (boolean)false);
        acceptor.setHandler(ioHandler);
        String host = this.connectionInformation.getTarget();
        if (host != null && (host.length() == 0 || "*".equals(host))) {
            host = null;
        }
        if (host != null) {
            acceptor.bind(socketImpl.doLookup(host, this.connectionInformation.getSecondaryTarget().intValue()));
        } else {
            acceptor.bind((SocketAddress)new InetSocketAddress(this.connectionInformation.getSecondaryTarget()));
        }
        return acceptor;
    }

    public void dispose() {
        if (this.acceptor != null) {
            this.acceptor.dispose();
            this.acceptor = null;
        }
    }
}

