/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ngp.common.codec.osbp;

import com.google.common.collect.Interner;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.filter.codec.ProtocolCodecException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.VariantType;
import org.eclipse.scada.core.ngp.common.codec.osbp.BinaryContext;
import org.eclipse.scada.protocol.ngp.common.utils.ArrayListAllocator;
import org.eclipse.scada.protocol.ngp.common.utils.CollectionAllocator;
import org.eclipse.scada.protocol.ngp.common.utils.HashSetAllocator;
import org.eclipse.scada.utils.interner.InternerHelper;

public class DefaultBinaryContext
implements BinaryContext {
    private static final ArrayListAllocator<String> ALLOC_STRING_LIST = new ArrayListAllocator();
    private static final HashSetAllocator<String> ALLOC_STRING_SET = new HashSetAllocator();
    private static final ArrayListAllocator<Long> ALLOC_LONG_LIST = new ArrayListAllocator();
    private static final HashSetAllocator<Long> ALLOC_LONG_SET = new HashSetAllocator();
    private static final ArrayListAllocator<Integer> ALLOC_INT_LIST = new ArrayListAllocator();
    private static final HashSetAllocator<Integer> ALLOC_INT_SET = new HashSetAllocator();
    private static final ArrayListAllocator<Boolean> ALLOC_BOOLEAN_LIST = new ArrayListAllocator();
    private static final HashSetAllocator<Boolean> ALLOC_BOOLEAN_SET = new HashSetAllocator();
    private static final ArrayListAllocator<Double> ALLOC_DOUBLE_LIST = new ArrayListAllocator();
    private static final HashSetAllocator<Double> ALLOC_DOUBLE_SET = new HashSetAllocator();
    private static final ArrayListAllocator<Variant> ALLOC_VARIANT_LIST = new ArrayListAllocator();
    private static final HashSetAllocator<Variant> ALLOC_VARIANT_SET = new HashSetAllocator();
    private static final ArrayListAllocator<Map<String, Variant>> ALLOC_VARIANT_MAP_LIST = new ArrayListAllocator();
    private static final HashSetAllocator<Map<String, Variant>> ALLOC_VARIANT_MAP_SET = new HashSetAllocator();
    private static final ArrayListAllocator<Map<String, String>> ALLOC_PROPERTIES_LIST = new ArrayListAllocator();
    private static final HashSetAllocator<Map<String, String>> ALLOC_PROPERTIES_SET = new HashSetAllocator();
    private static final byte TYPE_NULL = 0;
    private static final byte TYPE_STRING = 1;
    private static final byte TYPE_STRING_LIST = 17;
    private static final byte TYPE_LONG = 2;
    private static final byte TYPE_LONG_LIST = 18;
    private static final byte TYPE_INT = 3;
    private static final byte TYPE_INT_LIST = 19;
    private static final byte TYPE_BOOLEAN = 4;
    private static final byte TYPE_BOOLEAN_LIST = 20;
    private static final byte TYPE_DOUBLE = 5;
    private static final byte TYPE_DOUBLE_LIST = 21;
    private static final byte TYPE_VARIANT = 6;
    private static final byte TYPE_VARIANT_LIST = 22;
    private static final byte TYPE_VARIANT_MAP = 7;
    private static final byte TYPE_VARIANT_MAP_LIST = 23;
    private static final byte TYPE_PROPERTIES = 8;
    private static final byte TYPE_PROPERTIES_LIST = 24;
    private static final byte TYPE_STRUCTURE = 9;
    private static final byte TYPE_STRUCTURE_LIST = 25;
    private static final byte TYPE_ENUM = 10;
    private static final byte TYPE_ENUM_LIST = 26;
    private static final byte TYPE_ENUM_SET = 42;
    private static final int STRING_PREFIX_LEN = 4;
    private final CharsetEncoder encoder;
    private final CharsetDecoder decoder;
    private final Interner<String> stringInterner;

    public DefaultBinaryContext(Charset charset, Interner<String> stringInterner) {
        this.encoder = charset.newEncoder();
        this.decoder = charset.newDecoder();
        this.stringInterner = stringInterner == null ? InternerHelper.makeNoOpInterner() : stringInterner;
    }

    public DefaultBinaryContext() {
        this(Charset.forName("UTF-8"), (Interner<String>)InternerHelper.makeInterner((String)"org.eclipse.scada.core.ngp.common.codec.osbp.stringInterner", (String)"java"));
    }

    @Override
    public String getProtocolIdPart() {
        return "osbp.v2";
    }

    private byte checkType(IoBuffer buffer, byte expectedType, boolean allowNull) throws Exception {
        byte type = buffer.get();
        if (allowNull && type == 0) {
            return type;
        }
        if (type != expectedType) {
            if (type == 0 && !allowNull) {
                throw new ProtocolCodecException(String.format("Failed to decode. Field is transmitted as null but defined as not-null.", new Object[0]));
            }
            throw new ProtocolCodecException(String.format("Failed to decode string: Expected type %02x, found: %02x", expectedType, type));
        }
        return type;
    }

    @Override
    public void encodeString(IoBuffer buffer, byte fieldNumber, String data) throws Exception {
        buffer.put(fieldNumber);
        if (data != null) {
            buffer.put((byte)1);
            buffer.putPrefixedString((CharSequence)data, 4, this.encoder);
        } else {
            buffer.put((byte)0);
        }
    }

    @Override
    public String decodeString(IoBuffer buffer) throws Exception {
        byte type = this.checkType(buffer, (byte)1, true);
        if (type == 0) {
            return null;
        }
        return (String)this.stringInterner.intern((Object)buffer.getPrefixedString(4, this.decoder));
    }

    @Override
    public void encodeStringCollection(IoBuffer buffer, byte fieldNumber, Collection<String> data) throws Exception {
        buffer.put(fieldNumber);
        if (data != null) {
            buffer.put((byte)17);
            buffer.putInt(data.size());
            for (String entry : data) {
                buffer.putPrefixedString((CharSequence)entry, 4, this.encoder);
            }
        } else {
            buffer.put((byte)0);
        }
    }

    private void fillStringCollection(IoBuffer buffer, int items, Collection<String> data) throws Exception {
        int i = 0;
        while (i < items) {
            data.add((String)this.stringInterner.intern((Object)buffer.getPrefixedString(4, this.decoder)));
            ++i;
        }
    }

    private <T extends Collection<String>> T decodeStringCollection(IoBuffer buffer, CollectionAllocator<String, T> allactor) throws Exception {
        byte type = this.checkType(buffer, (byte)17, true);
        if (type == 0) {
            return null;
        }
        int items = buffer.getInt();
        Collection result = allactor.allocate(items);
        this.fillStringCollection(buffer, items, result);
        return (T)result;
    }

    @Override
    public List<String> decodeStringList(IoBuffer buffer) throws Exception {
        return (List)this.decodeStringCollection(buffer, (CollectionAllocator)ALLOC_STRING_LIST);
    }

    @Override
    public Set<String> decodeStringSet(IoBuffer buffer) throws Exception {
        return (Set)this.decodeStringCollection(buffer, (CollectionAllocator)ALLOC_STRING_SET);
    }

    @Override
    public void encodeLong(IoBuffer buffer, byte fieldNumber, Long data) throws Exception {
        buffer.put(fieldNumber);
        if (data != null) {
            buffer.put((byte)2);
            buffer.putLong(data.longValue());
        } else {
            buffer.put((byte)0);
        }
    }

    @Override
    public Long decodeLong(IoBuffer buffer) throws Exception {
        byte type = this.checkType(buffer, (byte)2, true);
        if (type == 0) {
            return null;
        }
        return buffer.getLong();
    }

    @Override
    public void encodePrimitiveLong(IoBuffer buffer, byte fieldNumber, long data) throws Exception {
        buffer.put(fieldNumber);
        buffer.put((byte)2);
        buffer.putLong(data);
    }

    @Override
    public long decodePrimitiveLong(IoBuffer buffer) throws Exception {
        this.checkType(buffer, (byte)2, false);
        return buffer.getLong();
    }

    @Override
    public void encodeLongCollection(IoBuffer buffer, byte fieldNumber, Collection<Long> data) throws Exception {
        buffer.put(fieldNumber);
        if (data != null) {
            buffer.put((byte)18);
            buffer.putInt(data.size());
            for (Long entry : data) {
                buffer.putLong(entry.longValue());
            }
        } else {
            buffer.put((byte)0);
        }
    }

    private void fillLongCollection(IoBuffer buffer, int items, Collection<Long> data) throws Exception {
        int i = 0;
        while (i < items) {
            data.add(buffer.getLong());
            ++i;
        }
    }

    private <T extends Collection<Long>> T decodeLongCollection(IoBuffer buffer, CollectionAllocator<Long, T> allactor) throws Exception {
        byte type = this.checkType(buffer, (byte)18, true);
        if (type == 0) {
            return null;
        }
        int items = buffer.getInt();
        Collection result = allactor.allocate(items);
        this.fillLongCollection(buffer, items, result);
        return (T)result;
    }

    @Override
    public List<Long> decodeLongList(IoBuffer buffer) throws Exception {
        return (List)this.decodeLongCollection(buffer, (CollectionAllocator)ALLOC_LONG_LIST);
    }

    @Override
    public Set<Long> decodeLongSet(IoBuffer buffer) throws Exception {
        return (Set)this.decodeLongCollection(buffer, (CollectionAllocator)ALLOC_LONG_SET);
    }

    @Override
    public void encodeInt(IoBuffer buffer, byte fieldNumber, Integer data) throws Exception {
        buffer.put(fieldNumber);
        if (data != null) {
            buffer.put((byte)3);
            buffer.putInt(data.intValue());
        } else {
            buffer.put((byte)0);
        }
    }

    @Override
    public Integer decodeInt(IoBuffer buffer) throws Exception {
        byte type = this.checkType(buffer, (byte)3, true);
        if (type == 0) {
            return null;
        }
        return buffer.getInt();
    }

    @Override
    public void encodePrimitiveInt(IoBuffer buffer, byte fieldNumber, int data) throws Exception {
        buffer.put(fieldNumber);
        buffer.put((byte)3);
        buffer.putInt(data);
    }

    @Override
    public int decodePrimitiveInt(IoBuffer buffer) throws Exception {
        this.checkType(buffer, (byte)3, false);
        return buffer.getInt();
    }

    @Override
    public void encodeIntCollection(IoBuffer buffer, byte fieldNumber, Collection<Integer> data) throws Exception {
        buffer.put(fieldNumber);
        if (data != null) {
            buffer.put((byte)19);
            buffer.putInt(data.size());
            for (Integer entry : data) {
                buffer.putInt(entry.intValue());
            }
        } else {
            buffer.put((byte)0);
        }
    }

    private void fillIntCollection(IoBuffer buffer, int items, Collection<Integer> data) throws Exception {
        int i = 0;
        while (i < items) {
            data.add(buffer.getInt());
            ++i;
        }
    }

    private <T extends Collection<Integer>> T decodeIntCollection(IoBuffer buffer, CollectionAllocator<Integer, T> allactor) throws Exception {
        byte type = this.checkType(buffer, (byte)19, true);
        if (type == 0) {
            return null;
        }
        int items = buffer.getInt();
        Collection result = allactor.allocate(items);
        this.fillIntCollection(buffer, items, result);
        return (T)result;
    }

    @Override
    public List<Integer> decodeIntList(IoBuffer buffer) throws Exception {
        return (List)this.decodeIntCollection(buffer, (CollectionAllocator)ALLOC_INT_LIST);
    }

    @Override
    public Set<Integer> decodeIntSet(IoBuffer buffer) throws Exception {
        return (Set)this.decodeIntCollection(buffer, (CollectionAllocator)ALLOC_INT_SET);
    }

    @Override
    public void encodeBoolean(IoBuffer buffer, byte fieldNumber, Boolean data) throws Exception {
        buffer.put(fieldNumber);
        if (data != null) {
            buffer.put((byte)4);
            buffer.put(data != false ? (byte)-1 : 0);
        } else {
            buffer.put((byte)0);
        }
    }

    @Override
    public Boolean decodeBoolean(IoBuffer buffer) throws Exception {
        byte type = this.checkType(buffer, (byte)4, true);
        if (type == 0) {
            return null;
        }
        if (buffer.get() != 0) {
            return true;
        }
        return false;
    }

    @Override
    public void encodePrimitiveBoolean(IoBuffer buffer, byte fieldNumber, boolean data) throws Exception {
        buffer.put(fieldNumber);
        buffer.put((byte)4);
        buffer.put(data ? (byte)-1 : 0);
    }

    @Override
    public boolean decodePrimitiveBoolean(IoBuffer buffer) throws Exception {
        this.checkType(buffer, (byte)4, false);
        return buffer.get() != 0;
    }

    @Override
    public void encodeBooleanCollection(IoBuffer buffer, byte fieldNumber, Collection<Boolean> data) throws Exception {
        buffer.put(fieldNumber);
        if (data != null) {
            buffer.put((byte)20);
            buffer.putInt(data.size());
            for (Boolean entry : data) {
                buffer.put(entry != false ? (byte)-1 : 0);
            }
        } else {
            buffer.put((byte)0);
        }
    }

    private void fillBooleanCollection(IoBuffer buffer, int items, Collection<Boolean> data) throws Exception {
        int i = 0;
        while (i < items) {
            data.add(buffer.get() != 0);
            ++i;
        }
    }

    private <T extends Collection<Boolean>> T decodeBooleanCollection(IoBuffer buffer, CollectionAllocator<Boolean, T> allactor) throws Exception {
        byte type = this.checkType(buffer, (byte)20, true);
        if (type == 0) {
            return null;
        }
        int items = buffer.getInt();
        Collection result = allactor.allocate(items);
        this.fillBooleanCollection(buffer, items, result);
        return (T)result;
    }

    @Override
    public List<Boolean> decodeBooleanList(IoBuffer buffer) throws Exception {
        return (List)this.decodeBooleanCollection(buffer, (CollectionAllocator)ALLOC_BOOLEAN_LIST);
    }

    @Override
    public Set<Boolean> decodeBooleanSet(IoBuffer buffer) throws Exception {
        return (Set)this.decodeBooleanCollection(buffer, (CollectionAllocator)ALLOC_BOOLEAN_SET);
    }

    @Override
    public void encodeDouble(IoBuffer buffer, byte fieldNumber, Double data) throws Exception {
        buffer.put(fieldNumber);
        if (data != null) {
            buffer.put((byte)5);
            buffer.putDouble(data.doubleValue());
        } else {
            buffer.put((byte)0);
        }
    }

    @Override
    public Double decodeDouble(IoBuffer buffer) throws Exception {
        byte type = this.checkType(buffer, (byte)5, true);
        if (type == 0) {
            return null;
        }
        return buffer.getDouble();
    }

    @Override
    public void encodePrimitiveDouble(IoBuffer buffer, byte fieldNumber, double data) throws Exception {
        buffer.put(fieldNumber);
        buffer.put((byte)5);
        buffer.putDouble(data);
    }

    @Override
    public double decodePrimitiveDouble(IoBuffer buffer) throws Exception {
        this.checkType(buffer, (byte)5, false);
        return buffer.getLong();
    }

    @Override
    public void encodeDoubleCollection(IoBuffer buffer, byte fieldNumber, Collection<Double> data) throws Exception {
        buffer.put(fieldNumber);
        if (data != null) {
            buffer.put((byte)21);
            buffer.putInt(data.size());
            for (Double entry : data) {
                buffer.putDouble(entry.doubleValue());
            }
        } else {
            buffer.put((byte)0);
        }
    }

    private void fillDoubleCollection(IoBuffer buffer, int items, Collection<Double> data) throws Exception {
        int i = 0;
        while (i < items) {
            data.add(buffer.getDouble());
            ++i;
        }
    }

    private <T extends Collection<Double>> T decodeDoubleCollection(IoBuffer buffer, CollectionAllocator<Double, T> allactor) throws Exception {
        byte type = this.checkType(buffer, (byte)21, true);
        if (type == 0) {
            return null;
        }
        int items = buffer.getInt();
        Collection result = allactor.allocate(items);
        this.fillDoubleCollection(buffer, items, result);
        return (T)result;
    }

    @Override
    public List<Double> decodeDoubleList(IoBuffer buffer) throws Exception {
        return (List)this.decodeDoubleCollection(buffer, (CollectionAllocator)ALLOC_DOUBLE_LIST);
    }

    @Override
    public Set<Double> decodeDoubleSet(IoBuffer buffer) throws Exception {
        return (Set)this.decodeDoubleCollection(buffer, (CollectionAllocator)ALLOC_DOUBLE_SET);
    }

    private void inlineEncodeVariant(IoBuffer buffer, Variant variant) throws Exception {
        VariantType type = variant.getType();
        buffer.putEnum((Enum)type);
        switch (type) {
            case BOOLEAN: {
                buffer.put(variant.asBoolean() ? (byte)-1 : 0);
                break;
            }
            case DOUBLE: {
                buffer.putDouble(variant.asDouble());
                break;
            }
            case INT32: {
                buffer.putInt(variant.asInteger());
                break;
            }
            case INT64: {
                buffer.putLong(variant.asLong());
                break;
            }
            case STRING: {
                buffer.putPrefixedString((CharSequence)variant.asString(), 4, this.encoder);
                break;
            }
            case NULL: {
                break;
            }
        }
    }

    private Variant inlineDecodeVariant(IoBuffer buffer) throws Exception {
        VariantType type = (VariantType)buffer.getEnum(VariantType.class);
        switch (type) {
            case BOOLEAN: {
                return Variant.valueOf((buffer.get() != 0 ? 1 : 0) != 0);
            }
            case DOUBLE: {
                return Variant.valueOf((double)buffer.getDouble());
            }
            case INT32: {
                return Variant.valueOf((int)buffer.getInt());
            }
            case INT64: {
                return Variant.valueOf((long)buffer.getLong());
            }
            case STRING: {
                return Variant.valueOf((Object)this.stringInterner.intern((Object)buffer.getPrefixedString(4, this.decoder)));
            }
        }
        return Variant.NULL;
    }

    @Override
    public void encodeVariant(IoBuffer buffer, byte fieldNumber, Variant data) throws Exception {
        buffer.put(fieldNumber);
        if (data != null) {
            buffer.put((byte)6);
            this.inlineEncodeVariant(buffer, data);
        } else {
            buffer.put((byte)0);
        }
    }

    @Override
    public Variant decodeVariant(IoBuffer buffer) throws Exception {
        byte type = this.checkType(buffer, (byte)6, true);
        if (type == 0) {
            return null;
        }
        return this.inlineDecodeVariant(buffer);
    }

    @Override
    public void encodeVariantCollection(IoBuffer buffer, byte fieldNumber, Collection<Variant> data) throws Exception {
        buffer.put(fieldNumber);
        if (data != null) {
            buffer.put((byte)22);
            buffer.putInt(data.size());
            for (Variant entry : data) {
                this.inlineEncodeVariant(buffer, entry);
            }
        } else {
            buffer.put((byte)0);
        }
    }

    private void fillVariantCollection(IoBuffer buffer, int items, Collection<Variant> data) throws Exception {
        int i = 0;
        while (i < items) {
            data.add(this.inlineDecodeVariant(buffer));
            ++i;
        }
    }

    private <T extends Collection<Variant>> T decodeVariantCollection(IoBuffer buffer, CollectionAllocator<Variant, T> allactor) throws Exception {
        byte type = this.checkType(buffer, (byte)22, true);
        if (type == 0) {
            return null;
        }
        int items = buffer.getInt();
        Collection result = allactor.allocate(items);
        this.fillVariantCollection(buffer, items, result);
        return (T)result;
    }

    @Override
    public List<Variant> decodeVariantList(IoBuffer buffer) throws Exception {
        return (List)this.decodeVariantCollection(buffer, (CollectionAllocator)ALLOC_VARIANT_LIST);
    }

    @Override
    public Set<Variant> decodeVariantSet(IoBuffer buffer) throws Exception {
        return (Set)this.decodeVariantCollection(buffer, (CollectionAllocator)ALLOC_VARIANT_SET);
    }

    protected void inlineEncodeVariantMap(IoBuffer buffer, Map<String, Variant> data) throws Exception {
        buffer.putInt(data.size());
        for (Map.Entry<String, Variant> entry : data.entrySet()) {
            buffer.putPrefixedString((CharSequence)entry.getKey(), 4, this.encoder);
            this.inlineEncodeVariant(buffer, entry.getValue());
        }
    }

    protected Map<String, Variant> inlineDecodeVariantMap(IoBuffer buffer) throws Exception {
        int len = buffer.getInt();
        HashMap<String, Variant> result = new HashMap<String, Variant>(len);
        int i = 0;
        while (i < len) {
            String key = (String)this.stringInterner.intern((Object)buffer.getPrefixedString(4, this.decoder));
            Variant value = this.inlineDecodeVariant(buffer);
            result.put(key, value);
            ++i;
        }
        return result;
    }

    @Override
    public void encodeVariantMap(IoBuffer buffer, byte fieldNumber, Map<String, Variant> data) throws Exception {
        buffer.put(fieldNumber);
        if (data != null) {
            buffer.put((byte)7);
            this.inlineEncodeVariantMap(buffer, data);
        } else {
            buffer.put((byte)0);
        }
    }

    @Override
    public Map<String, Variant> decodeVariantMap(IoBuffer buffer) throws Exception {
        byte type = this.checkType(buffer, (byte)7, true);
        if (type == 0) {
            return null;
        }
        return this.inlineDecodeVariantMap(buffer);
    }

    @Override
    public void encodeVariantMapCollection(IoBuffer buffer, byte fieldNumber, Collection<Map<String, Variant>> data) throws Exception {
        buffer.put(fieldNumber);
        if (data != null) {
            buffer.put((byte)8);
            buffer.putInt(data.size());
            for (Map<String, Variant> entry : data) {
                this.inlineEncodeVariantMap(buffer, entry);
            }
        } else {
            buffer.put((byte)0);
        }
    }

    private void fillVariantMapCollection(IoBuffer buffer, int items, Collection<Map<String, Variant>> data) throws Exception {
        int i = 0;
        while (i < items) {
            data.add(this.inlineDecodeVariantMap(buffer));
            ++i;
        }
    }

    private <T extends Collection<Map<String, Variant>>> T decodeVariantMapCollection(IoBuffer buffer, CollectionAllocator<Map<String, Variant>, T> allactor) throws Exception {
        byte type = this.checkType(buffer, (byte)23, true);
        if (type == 0) {
            return null;
        }
        int items = buffer.getInt();
        Collection result = allactor.allocate(items);
        this.fillVariantMapCollection(buffer, items, result);
        return (T)result;
    }

    @Override
    public List<Map<String, Variant>> decodeVariantMapList(IoBuffer buffer) throws Exception {
        return (List)this.decodeVariantMapCollection(buffer, (CollectionAllocator)ALLOC_VARIANT_MAP_LIST);
    }

    @Override
    public Set<Map<String, Variant>> decodeVariantMapSet(IoBuffer buffer) throws Exception {
        return (Set)this.decodeVariantMapCollection(buffer, (CollectionAllocator)ALLOC_VARIANT_MAP_SET);
    }

    protected void inlineEncodeProperties(IoBuffer buffer, Map<String, String> data) throws Exception {
        buffer.putInt(data.size());
        for (Map.Entry<String, String> entry : data.entrySet()) {
            buffer.putPrefixedString((CharSequence)entry.getKey(), 4, this.encoder);
            buffer.putPrefixedString((CharSequence)entry.getValue(), 4, this.encoder);
        }
    }

    protected Map<String, String> inlineDecodeProperties(IoBuffer buffer) throws Exception {
        int len = buffer.getInt();
        HashMap<String, String> result = new HashMap<String, String>(len);
        int i = 0;
        while (i < len) {
            String key = (String)this.stringInterner.intern((Object)buffer.getPrefixedString(4, this.decoder));
            String value = (String)this.stringInterner.intern((Object)buffer.getPrefixedString(4, this.decoder));
            result.put(key, value);
            ++i;
        }
        return result;
    }

    @Override
    public void encodeProperties(IoBuffer buffer, byte fieldNumber, Map<String, String> data) throws Exception {
        buffer.put(fieldNumber);
        if (data != null) {
            buffer.put((byte)8);
            this.inlineEncodeProperties(buffer, data);
        } else {
            buffer.put((byte)0);
        }
    }

    @Override
    public Map<String, String> decodeProperties(IoBuffer buffer) throws Exception {
        byte type = this.checkType(buffer, (byte)8, true);
        if (type == 0) {
            return null;
        }
        return this.inlineDecodeProperties(buffer);
    }

    @Override
    public void encodePropertiesCollection(IoBuffer buffer, byte fieldNumber, Collection<Map<String, String>> data) throws Exception {
        buffer.put(fieldNumber);
        if (data != null) {
            buffer.put((byte)8);
            buffer.putInt(data.size());
            for (Map<String, String> entry : data) {
                this.inlineEncodeProperties(buffer, entry);
            }
        } else {
            buffer.put((byte)0);
        }
    }

    private void fillPropertiesCollection(IoBuffer buffer, int items, Collection<Map<String, String>> data) throws Exception {
        int i = 0;
        while (i < items) {
            data.add(this.inlineDecodeProperties(buffer));
            ++i;
        }
    }

    private <T extends Collection<Map<String, String>>> T decodePropertiesCollection(IoBuffer buffer, CollectionAllocator<Map<String, String>, T> allactor) throws Exception {
        byte type = this.checkType(buffer, (byte)24, true);
        if (type == 0) {
            return null;
        }
        int items = buffer.getInt();
        Collection result = allactor.allocate(items);
        this.fillPropertiesCollection(buffer, items, result);
        return (T)result;
    }

    @Override
    public List<Map<String, String>> decodePropertiesList(IoBuffer buffer) throws Exception {
        return (List)this.decodePropertiesCollection(buffer, (CollectionAllocator)ALLOC_PROPERTIES_LIST);
    }

    @Override
    public Set<Map<String, String>> decodePropertiesSet(IoBuffer buffer) throws Exception {
        return (Set)this.decodePropertiesCollection(buffer, (CollectionAllocator)ALLOC_PROPERTIES_SET);
    }

    protected void inlineEncodeEnum(IoBuffer data, Enum<?> value) {
        data.putEnum(value);
    }

    protected <E extends Enum<E>> E inlineDecodeEnum(IoBuffer data, Class<E> enumClazz) {
        return (E)data.getEnum(enumClazz);
    }

    @Override
    public <E extends Enum<E>> void encodeEnum(IoBuffer buffer, byte fieldNumber, E value) throws Exception {
        buffer.put(fieldNumber);
        if (value != null) {
            buffer.put((byte)10);
            this.inlineEncodeEnum(buffer, value);
        } else {
            buffer.put((byte)0);
        }
    }

    @Override
    public <E extends Enum<E>> E decodeEnum(IoBuffer buffer, Class<E> enumClazz) throws Exception {
        byte type = this.checkType(buffer, (byte)10, true);
        if (type == 0) {
            return null;
        }
        return this.inlineDecodeEnum(buffer, enumClazz);
    }

    @Override
    public <E extends Enum<E>> void encodeEnumList(IoBuffer buffer, byte fieldNumber, List<E> data) throws Exception {
        buffer.put(fieldNumber);
        if (data != null) {
            buffer.put((byte)26);
            buffer.putInt(data.size());
            for (Enum entry : data) {
                this.inlineEncodeEnum(buffer, entry);
            }
        } else {
            buffer.put((byte)0);
        }
    }

    @Override
    public <E extends Enum<E>> List<E> decodeEnumList(IoBuffer buffer, Class<E> enumClazz) throws Exception {
        byte type = this.checkType(buffer, (byte)26, true);
        if (type == 0) {
            return null;
        }
        int len = buffer.getInt();
        ArrayList<E> result = new ArrayList<E>(len);
        int i = 0;
        while (i < len) {
            result.add(this.inlineDecodeEnum(buffer, enumClazz));
            ++i;
        }
        return result;
    }

    @Override
    public <E extends Enum<E>> void encodeEnumSet(IoBuffer buffer, byte fieldNumber, Set<E> data) throws Exception {
        buffer.put(fieldNumber);
        if (data != null) {
            buffer.put((byte)42);
            buffer.putEnumSetShort(data);
        } else {
            buffer.put((byte)0);
        }
    }

    @Override
    public <E extends Enum<E>> Set<E> decodeEnumSet(IoBuffer buffer, Class<E> enumClazz) throws Exception {
        byte type = this.checkType(buffer, (byte)42, true);
        if (type == 0) {
            return null;
        }
        return buffer.getEnumSetShort(enumClazz);
    }

    @Override
    public boolean beginReadStructure(IoBuffer buffer, boolean allowNull) throws Exception {
        byte type = this.checkType(buffer, (byte)9, allowNull);
        return type == 0;
    }

    @Override
    public void beginWriteStructure(IoBuffer buffer, byte fieldNumber, boolean isNull) throws Exception {
        buffer.put(fieldNumber);
        buffer.put(isNull ? (byte)0 : 9);
    }

    @Override
    public Integer beginReadStructureList(IoBuffer buffer, boolean allowNull) throws Exception {
        byte type = this.checkType(buffer, (byte)25, allowNull);
        if (type == 0) {
            return null;
        }
        return buffer.getInt();
    }

    @Override
    public void beginWriteStructureList(IoBuffer buffer, byte fieldNumber, Collection<?> values) throws Exception {
        buffer.put(fieldNumber);
        if (values != null) {
            buffer.put((byte)25);
            buffer.putInt(values.size());
        } else {
            buffer.put((byte)0);
        }
    }
}

