/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.storage.postgres;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.UUID;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.server.storage.postgres.EventConverter;
import org.eclipse.scada.ae.server.storage.postgres.NodeIdProvider;
import org.eclipse.scada.ae.server.storage.postgres.NotSupportedException;
import org.eclipse.scada.ae.server.storage.postgres.internal.SqlConverter;
import org.eclipse.scada.utils.filter.Filter;
import org.eclipse.scada.utils.osgi.jdbc.CommonConnectionAccessor;
import org.eclipse.scada.utils.osgi.jdbc.data.RowMapper;
import org.eclipse.scada.utils.osgi.jdbc.data.RowMapperAdapter;
import org.eclipse.scada.utils.osgi.jdbc.data.RowMapperMappingException;
import org.eclipse.scada.utils.osgi.jdbc.task.CommonConnectionTask;
import org.eclipse.scada.utils.osgi.jdbc.task.ConnectionContext;
import org.eclipse.scada.utils.osgi.jdbc.task.ConnectionTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcDao {
    private static final Logger logger = LoggerFactory.getLogger(JdbcDao.class);
    private static final String cleanupArchiveSql = "DELETE FROM %sES_AE_EVENTS_JSON WHERE instance_id = ? AND SOURCE_TIMESTAMP < ?";
    private static final String loadEventSql = "SELECT data FROM %sES_AE_EVENTS_JSON WHERE instance_id = ? AND ID = ?::UUID";
    private static final String storeEventSql = "INSERT INTO %sES_AE_EVENTS_JSON (id, instance_id, source_timestamp, entry_timestamp, data) VALUES (?::UUID, ?, ?, ?, ?);";
    private static final String replicateEventSql = "INSERT INTO %sES_AE_REP (id, entry_timestamp, node_id, data) VALUES (?::VARCHAR, ?, ?, ?);";
    private static final String updateEventSql = "UPDATE %sES_AE_EVENTS_JSON SET data = ? WHERE id = ?::UUID;";
    private static final String selectEventsSql = "SELECT data FROM %sES_AE_EVENTS_JSON WHERE instance_id = ? ";
    private static final String defaultOrderSql = " ORDER BY source_timestamp DESC, entry_timestamp DESC, id DESC;";
    private static final int NODE_ID_LENGTH = Integer.getInteger("org.eclipse.scada.ae.server.storage.jdbc.fields.nodeId.length", 32);
    public final ReplicationDataFormat dataFormat = this.makeDataFormat();
    private final CommonConnectionAccessor accessor;
    private final String schema;
    private final String instance;
    private final NodeIdProvider nodeIdProvider;

    public JdbcDao(CommonConnectionAccessor accessor, String schema, String instance, NodeIdProvider nodeIdProvider) {
        this.accessor = accessor;
        this.schema = schema;
        this.instance = instance;
        this.nodeIdProvider = nodeIdProvider;
    }

    public Event load(final UUID id) {
        logger.trace("try to load event with id {}", (Object)id);
        return (Event)this.accessor.doWithConnection((ConnectionTask)new CommonConnectionTask<Event>(){

            protected Event performTask(ConnectionContext connectionContext) throws Exception {
                return (Event)connectionContext.queryForObject((RowMapper)EventRowMapper.INSTANCE, String.format(JdbcDao.loadEventSql, JdbcDao.this.schema), new Object[]{JdbcDao.this.instance, id});
            }
        });
    }

    public void store(ConnectionContext connectionContext, Event event) throws SQLException {
        logger.trace("try to store event {}", (Object)event);
        Object[] parameters = new Object[]{event.getId(), this.instance, new Timestamp(event.getSourceTimestamp().getTime()), new Timestamp(event.getEntryTimestamp().getTime()), EventConverter.INSTANCE.toJson(event)};
        connectionContext.update(String.format(storeEventSql, this.schema), parameters);
    }

    public void storeReplication(ConnectionContext connectionContext, Event event) throws SQLException, IOException {
        logger.trace("try to store replication event {}", (Object)event);
        Object[] parameters = new Object[4];
        parameters[0] = event.getId();
        parameters[1] = new Timestamp(event.getEntryTimestamp().getTime());
        parameters[2] = this.clip(NODE_ID_LENGTH, this.nodeIdProvider.getNodeId());
        switch (this.dataFormat) {
            case JSON: {
                parameters[3] = EventConverter.INSTANCE.toJson(event);
                break;
            }
            case BLOB: {
                Blob blob = connectionContext.getConnection().createBlob();
                ObjectOutputStream oos = new ObjectOutputStream(blob.setBinaryStream(1L));
                oos.writeObject(event);
                oos.close();
                parameters[3] = blob;
                break;
            }
            default: {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(event);
                oos.close();
                parameters[3] = bos.toByteArray();
            }
        }
        connectionContext.update(String.format(replicateEventSql, this.schema), parameters);
    }

    public void update(ConnectionContext connectionContext, Event event) throws SQLException {
        logger.trace("try to update event {}", (Object)event);
        connectionContext.update(String.format(updateEventSql, this.schema), new Object[]{EventConverter.INSTANCE.toJson(event), event.getId()});
    }

    public int cleanUp(final Date date) {
        logger.trace("cleanUp called with date {}", (Object)date);
        return (Integer)this.accessor.doWithConnection((ConnectionTask)new CommonConnectionTask<Integer>(){

            protected Integer performTask(ConnectionContext connectionContext) throws Exception {
                connectionContext.setAutoCommit(false);
                int i = connectionContext.update(String.format(JdbcDao.cleanupArchiveSql, JdbcDao.this.schema), new Object[]{JdbcDao.this.instance, new Timestamp(date.getTime())});
                connectionContext.commit();
                return i;
            }
        });
    }

    public ResultSet queryEvents(Filter filter) throws SQLException, NotSupportedException {
        Connection con = this.accessor.getConnection();
        SqlConverter.SqlCondition condition = SqlConverter.toSql(this.schema, filter);
        String sql = selectEventsSql + condition.condition + defaultOrderSql;
        String querySql = String.format(sql, this.schema);
        logger.debug("executing query: {} with parameters {}", (Object)querySql, condition.parameters);
        PreparedStatement stm = con.prepareStatement(querySql, 1003, 1007);
        stm.setFetchSize(Integer.getInteger("org.eclipse.scada.ae.server.storage.jdbc.query.fetchSize", 1000));
        int i = 1;
        stm.setString(1, this.instance);
        for (Serializable parameter : condition.parameters) {
            stm.setObject(++i, parameter);
        }
        ResultSet rs = stm.executeQuery();
        logger.debug("query completed, returning resultset");
        return rs;
    }

    private String clip(int i, String string) {
        if (string == null) {
            return null;
        }
        if (i < 1 || string.length() <= i) {
            return string;
        }
        return string.substring(0, i);
    }

    private ReplicationDataFormat makeDataFormat() {
        try {
            return ReplicationDataFormat.valueOf(System.getProperty("org.eclipse.scada.ae.server.storage.jdbc.replicationDataFormat", ReplicationDataFormat.BYTES.name()));
        }
        catch (Exception exception) {
            return ReplicationDataFormat.BYTES;
        }
    }

    private static class EventRowMapper
    extends RowMapperAdapter<Event> {
        private static EventRowMapper INSTANCE = new EventRowMapper();

        private EventRowMapper() {
        }

        public Event mapRow(ResultSet resultSet) throws SQLException, RowMapperMappingException {
            String json = resultSet.getString(1);
            return EventConverter.INSTANCE.toEvent(json);
        }

        public Event nullObject() {
            return Event.NULL_EVENT;
        }
    }

    public static enum ReplicationDataFormat {
        BLOB,
        BYTES,
        JSON;

    }
}

