/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.server.storage.master.hds;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.scada.hd.server.storage.master.hds.StorageManager;
import org.eclipse.scada.hd.server.storage.master.hds.console.Console;
import org.eclipse.scada.hds.DataFilePool;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger logger = LoggerFactory.getLogger(Activator.class);
    private static BundleContext context;
    private StorageManager manager;
    private DataFilePool pool;

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        this.pool = new DataFilePool(Integer.getInteger("org.eclipse.scada.hd.server.storage.master.hds.instanceCountTarget", 10).intValue());
        this.manager = new StorageManager(bundleContext, this.pool);
        this.registerConsole();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.manager.dispose();
        this.manager = null;
        this.pool.dispose();
        context = null;
    }

    private void registerConsole() {
        try {
            Console console = new Console(this.manager);
            Hashtable<String, Object> properties = new Hashtable<String, Object>();
            ((Dictionary)properties).put("osgi.command.scope", "hds");
            ((Dictionary)properties).put("osgi.command.function", new String[]{"list", "purgeAll", "remove", "create"});
            context.registerService(Console.class, (Object)console, properties);
        }
        catch (Exception e) {
            logger.warn("Failed to register console", (Throwable)e);
        }
    }
}

