/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.net.handler;

import java.util.Map;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.data.OperationParameters;
import org.eclipse.scada.core.net.MessageHelper;
import org.eclipse.scada.da.core.WriteAttributeResult;
import org.eclipse.scada.da.core.WriteAttributeResults;
import org.eclipse.scada.net.base.data.LongValue;
import org.eclipse.scada.net.base.data.MapValue;
import org.eclipse.scada.net.base.data.Message;
import org.eclipse.scada.net.base.data.StringValue;
import org.eclipse.scada.net.base.data.Value;
import org.eclipse.scada.net.base.data.VoidValue;
import org.eclipse.scada.utils.lang.Holder;

public class WriteAttributesOperation {
    public static Message createRequest(String itemId, Map<String, Variant> attributes, OperationParameters operationParameters) {
        Message message = new Message(65616);
        message.getValues().put("item-id", (Value)new StringValue(itemId));
        message.getValues().put("attributes", (Value)MessageHelper.attributesToMap(attributes));
        MessageHelper.encodeOperationParameters((OperationParameters)operationParameters, (Message)message);
        return message;
    }

    public static void parseRequest(Message message, Holder<String> itemId, Holder<Map<String, Variant>> attributes, Holder<OperationParameters> operationParameters) {
        itemId.value = message.getValues().get("item-id").toString();
        Value value = message.getValues().get("attributes");
        if (value instanceof MapValue) {
            attributes.value = MessageHelper.mapToAttributes((MapValue)((MapValue)value));
        }
        operationParameters.value = MessageHelper.convertOperationParameters((Value)message.getValues().get("operation-parameters"));
    }

    public static Message createResponse(long id, WriteAttributeResults writeAttributeResults) {
        Message message = new Message(65600);
        message.getValues().put("id", (Value)new LongValue(id));
        MapValue resultValues = new MapValue();
        for (Map.Entry writeAttributeResult : writeAttributeResults.entrySet()) {
            if (((WriteAttributeResult)writeAttributeResult.getValue()).isError()) {
                resultValues.put((String)writeAttributeResult.getKey(), (Value)new StringValue(((WriteAttributeResult)writeAttributeResult.getValue()).toString()));
                continue;
            }
            resultValues.put((String)writeAttributeResult.getKey(), (Value)VoidValue.INSTANCE);
        }
        message.getValues().put("results", (Value)resultValues);
        return message;
    }

    public static Message createResponse(long id, Throwable error) {
        Message message = new Message(65600);
        message.getValues().put("id", (Value)new LongValue(id));
        if (error.getMessage() != null) {
            message.getValues().put("error-info", (Value)new StringValue(error.getMessage()));
        } else {
            message.getValues().put("error-info", (Value)new StringValue(error.toString()));
        }
        return message;
    }

    public static WriteAttributeResults parseResponse(Message message) throws Exception {
        WriteAttributeResults writeAttributeResults = new WriteAttributeResults();
        if (message.getValues().containsKey("error-info")) {
            throw new Exception(message.getValues().get("error-info").toString());
        }
        if (message.getValues().containsKey("results") && message.getValues().get("results") instanceof MapValue) {
            MapValue resultValues = (MapValue)message.getValues().get("results");
            for (Map.Entry entry : resultValues.getValues().entrySet()) {
                String name = (String)entry.getKey();
                if (entry.getValue() instanceof VoidValue) {
                    writeAttributeResults.put((Object)name, (Object)WriteAttributeResult.OK);
                    continue;
                }
                writeAttributeResults.put((Object)name, (Object)new WriteAttributeResult((Throwable)new Exception(((Value)entry.getValue()).toString())));
            }
        }
        return writeAttributeResults;
    }
}

