/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.eclipse.scada.ae.Query;
import org.eclipse.scada.ae.QueryListener;
import org.eclipse.scada.ae.UnknownQueryException;
import org.eclipse.scada.ae.data.BrowserEntry;
import org.eclipse.scada.ae.data.BrowserType;
import org.eclipse.scada.ae.server.Service;
import org.eclipse.scada.ae.server.Session;
import org.eclipse.scada.ae.server.common.QueryImpl;
import org.eclipse.scada.ae.server.common.SessionImpl;
import org.eclipse.scada.ae.server.common.akn.AknHandler;
import org.eclipse.scada.ae.server.common.event.EventQuery;
import org.eclipse.scada.ae.server.common.event.EventQuerySource;
import org.eclipse.scada.ae.server.common.monitor.MonitorQuery;
import org.eclipse.scada.ae.server.common.monitor.MonitorQuerySource;
import org.eclipse.scada.core.InvalidSessionException;
import org.eclipse.scada.core.data.OperationParameters;
import org.eclipse.scada.core.server.common.AuthorizedOperation;
import org.eclipse.scada.core.server.common.osgi.AbstractServiceImpl;
import org.eclipse.scada.core.server.common.session.AbstractSessionImpl;
import org.eclipse.scada.core.subscription.SubscriptionListener;
import org.eclipse.scada.core.subscription.SubscriptionManager;
import org.eclipse.scada.core.subscription.SubscriptionSource;
import org.eclipse.scada.core.subscription.ValidationException;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.utils.concurrent.InstantFuture;
import org.eclipse.scada.utils.concurrent.NamedThreadFactory;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceImpl
extends AbstractServiceImpl<Session, SessionImpl>
implements Service,
ServiceListener {
    private static final Logger logger = LoggerFactory.getLogger(ServiceImpl.class);
    private final SubscriptionManager monitorSubscriptions;
    private final SubscriptionManager eventSubscriptions;
    private final BundleContext context;
    private final Map<String, MonitorQuery> conditionQueryRefs = new HashMap<String, MonitorQuery>();
    private final Map<String, EventQuery> eventQueryRefs = new HashMap<String, EventQuery>();
    private final Map<String, BrowserEntry> browserCache = new HashMap<String, BrowserEntry>();
    private final ServiceTracker<AknHandler, AknHandler> aknTracker;
    private ExecutorService queryLoadExecutor;
    private ExecutorService eventExecutor;
    private ServiceListener conditionServiceListener;
    private ServiceListener eventServiceListener;

    public ServiceImpl(BundleContext context, Executor executor) throws InvalidSyntaxException {
        super(context, executor);
        this.context = context;
        this.monitorSubscriptions = new SubscriptionManager();
        this.eventSubscriptions = new SubscriptionManager();
        this.aknTracker = new ServiceTracker(context, AknHandler.class, null);
    }

    public NotifyFuture<Void> acknowledge(Session session, final String monitorId, final Date aknTimestamp, OperationParameters operationParameters, final CallbackHandler callbackHandler) throws InvalidSessionException {
        SessionImpl sessionImpl = (SessionImpl)this.validateSession((org.eclipse.scada.core.server.Session)session, SessionImpl.class);
        logger.debug("Request akn: {} ({}): sessionUser: {}", new Object[]{monitorId, aknTimestamp, sessionImpl.getUserInformation()});
        return new AuthorizedOperation<Void, AbstractSessionImpl>(this.authorizationProvider, (AbstractSessionImpl)sessionImpl, "MONITOR", monitorId, "AKN", null, operationParameters, callbackHandler, DEFAULT_RESULT){

            protected NotifyFuture<Void> granted(org.eclipse.scada.core.server.OperationParameters effectiveOperationParameters) {
                ServiceImpl.this.processAcknowledge(monitorId, aknTimestamp, effectiveOperationParameters, callbackHandler);
                return new InstantFuture(null);
            }
        };
    }

    protected void processAcknowledge(String monitorId, Date aknTimestamp, org.eclipse.scada.core.server.OperationParameters operationParameters, CallbackHandler callbackHandler) {
        logger.debug("Processing akn: {} ({}): effective: {}", new Object[]{monitorId, aknTimestamp, operationParameters.getUserInformation().getName()});
        Object[] objectArray = this.aknTracker.getServices();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof AknHandler && ((AknHandler)o).acknowledge(monitorId, operationParameters, aknTimestamp)) break;
            ++n2;
        }
    }

    protected void addMonitorQuery(String id, MonitorQuery query) {
        logger.info("Adding new query: {}", (Object)id);
        this.monitorSubscriptions.setSource((Object)id, (SubscriptionSource)new MonitorQuerySource(id, query));
        HashMap attributes = new HashMap();
        BrowserEntry entry = new BrowserEntry(id, EnumSet.of(BrowserType.MONITORS), attributes);
        this.triggerBrowserChange(Arrays.asList(entry), null, false);
    }

    protected void removeMonitorQuery(String id, MonitorQuery query) {
        logger.info("Removing query: {}", (Object)id);
        this.monitorSubscriptions.setSource((Object)id, null);
        this.triggerBrowserChange(null, Collections.singleton(id), false);
    }

    protected void addEventQuery(String id, EventQuery query) {
        logger.info("Adding new event query: {}", (Object)id);
        this.eventSubscriptions.setSource((Object)id, (SubscriptionSource)new EventQuerySource(id, query));
        HashMap attributes = new HashMap();
        BrowserEntry entry = new BrowserEntry(id, EnumSet.of(BrowserType.EVENTS), attributes);
        this.triggerBrowserChange(Arrays.asList(entry), null, false);
    }

    protected void removeEventQuery(String id, EventQuery query) {
        logger.info("Removing event query: {}", (Object)id);
        this.eventSubscriptions.setSource((Object)id, null);
        this.triggerBrowserChange(null, Collections.singleton(id), false);
        logger.info("Removed event query: {}", (Object)id);
    }

    protected synchronized void triggerBrowserChange(List<BrowserEntry> entries, Set<String> removed, boolean full) {
        if (full) {
            this.browserCache.clear();
        }
        if (removed != null) {
            for (String id : removed) {
                this.browserCache.remove(id);
            }
        }
        if (entries != null) {
            for (BrowserEntry entry : entries) {
                this.browserCache.put(entry.getId(), entry);
            }
        }
        for (SessionImpl session : this.sessions) {
            session.dataChanged(entries, removed, full);
        }
    }

    public Query createQuery(Session session, String queryType, String queryData, QueryListener listener) throws InvalidSessionException {
        SessionImpl sessionImpl = (SessionImpl)this.validateSession((org.eclipse.scada.core.server.Session)session, SessionImpl.class);
        QueryImpl query = new QueryImpl(this.context, sessionImpl, this.eventExecutor, this.queryLoadExecutor, queryType, queryData, listener);
        sessionImpl.addQuery(query);
        if (!query.isDisposed()) {
            query.start();
            return query;
        }
        throw new InvalidSessionException();
    }

    public void subscribeConditionQuery(Session session, String queryId) throws InvalidSessionException, UnknownQueryException {
        SessionImpl sessionImpl = (SessionImpl)this.validateSession((org.eclipse.scada.core.server.Session)session, SessionImpl.class);
        logger.info("Request condition subscription: " + queryId);
        try {
            this.monitorSubscriptions.subscribe((Object)queryId, (SubscriptionListener)sessionImpl.getMonitorListener());
        }
        catch (ValidationException e) {
            logger.warn("Failed to subscribe", (Throwable)e);
            throw new UnknownQueryException();
        }
    }

    public void unsubscribeConditionQuery(Session session, String queryId) throws InvalidSessionException {
        SessionImpl sessionImpl = (SessionImpl)this.validateSession((org.eclipse.scada.core.server.Session)session, SessionImpl.class);
        logger.info("Request condition unsubscription: " + queryId);
        this.monitorSubscriptions.unsubscribe((Object)queryId, (SubscriptionListener)sessionImpl.getMonitorListener());
    }

    public void subscribeEventQuery(Session session, String queryId) throws InvalidSessionException, UnknownQueryException {
        SessionImpl sessionImpl = (SessionImpl)this.validateSession((org.eclipse.scada.core.server.Session)session, SessionImpl.class);
        logger.info("Request event subscription: " + queryId);
        try {
            this.eventSubscriptions.subscribe((Object)queryId, (SubscriptionListener)sessionImpl.getEventListener());
        }
        catch (ValidationException e) {
            logger.warn("Failed to subscribe", (Throwable)e);
            throw new UnknownQueryException();
        }
    }

    public void unsubscribeEventQuery(Session session, String queryId) throws InvalidSessionException {
        SessionImpl sessionImpl = (SessionImpl)this.validateSession((org.eclipse.scada.core.server.Session)session, SessionImpl.class);
        logger.info("Request event unsubscription: " + queryId);
        this.eventSubscriptions.unsubscribe((Object)queryId, (SubscriptionListener)sessionImpl.getEventListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSession(Session session) throws InvalidSessionException {
        SessionImpl sessionImpl = null;
        ServiceImpl serviceImpl = this;
        synchronized (serviceImpl) {
            if (this.sessions.remove(session)) {
                sessionImpl = (SessionImpl)session;
                sessionImpl.dispose();
            }
        }
        if (sessionImpl != null) {
            this.monitorSubscriptions.unsubscribeAll((SubscriptionListener)sessionImpl.getMonitorListener());
            this.eventSubscriptions.unsubscribeAll((SubscriptionListener)sessionImpl.getEventListener());
        }
    }

    protected SessionImpl createSessionInstance(UserInformation user, Map<String, String> sessionProperties) {
        final SessionImpl session = new SessionImpl(user, sessionProperties);
        this.sessions.add(session);
        final ArrayList<BrowserEntry> browserCache = new ArrayList<BrowserEntry>(this.browserCache.values());
        if (!browserCache.isEmpty()) {
            this.eventExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    session.dataChanged(browserCache, null, true);
                }
            });
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() throws Exception {
        Collection refs;
        logger.info("Staring new service");
        super.start();
        this.queryLoadExecutor = Executors.newCachedThreadPool((ThreadFactory)new NamedThreadFactory("ServiceImpl/QueryLoad"));
        this.eventExecutor = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("ServiceImpl/Event"));
        ServiceImpl serviceImpl = this;
        synchronized (serviceImpl) {
            this.conditionServiceListener = new ServiceListener(){

                public void serviceChanged(ServiceEvent event) {
                    ServiceImpl.this.serviceChanged(event);
                }
            };
            this.context.addServiceListener(this.conditionServiceListener, "(objectClass=" + MonitorQuery.class.getName() + ")");
            refs = this.context.getServiceReferences(MonitorQuery.class, null);
            if (refs != null) {
                for (ServiceReference ref : refs) {
                    this.checkAddConditionQuery(ref);
                }
            }
        }
        serviceImpl = this;
        synchronized (serviceImpl) {
            this.eventServiceListener = new ServiceListener(){

                public void serviceChanged(ServiceEvent event) {
                    ServiceImpl.this.serviceChanged(event);
                }
            };
            this.context.addServiceListener(this.eventServiceListener, "(objectClass=" + EventQuery.class.getName() + ")");
            refs = this.context.getServiceReferences(EventQuery.class, null);
            if (refs != null) {
                for (ServiceReference ref : refs) {
                    this.checkAddEventQuery(ref);
                }
            }
        }
        this.aknTracker.open(true);
    }

    public synchronized void stop() throws Exception {
        logger.info("Stopping service");
        for (SessionImpl session : this.sessions) {
            session.dispose();
        }
        this.context.removeServiceListener(this.conditionServiceListener);
        this.context.removeServiceListener(this.eventServiceListener);
        this.conditionServiceListener = null;
        this.eventServiceListener = null;
        this.aknTracker.close();
        this.queryLoadExecutor.shutdown();
        this.queryLoadExecutor = null;
        this.eventExecutor.shutdown();
        this.eventExecutor = null;
        super.stop();
    }

    public synchronized void serviceChanged(ServiceEvent event) {
        logger.debug("Service changed: {}", (Object)event);
        ServiceReference ref = event.getServiceReference();
        try {
            switch (event.getType()) {
                case 1: {
                    this.checkAddConditionQuery(ref);
                    this.checkAddEventQuery(ref);
                    break;
                }
                case 4: {
                    EventQuery eventQuery;
                    String id = this.getQueryId(ref);
                    MonitorQuery query = this.conditionQueryRefs.remove(id);
                    if (query != null) {
                        this.removeMonitorQuery(id, query);
                        this.context.ungetService(ref);
                    }
                    if ((eventQuery = this.eventQueryRefs.remove(id)) == null) break;
                    this.removeEventQuery(id, eventQuery);
                    this.context.ungetService(ref);
                }
                default: {
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.warn("Failed to handle service change", (Throwable)e);
        }
    }

    private void checkAddConditionQuery(ServiceReference<?> ref) {
        logger.info("Checking query: " + ref);
        Object o = this.context.getService(ref);
        if (o instanceof MonitorQuery) {
            MonitorQuery query = (MonitorQuery)o;
            String id = this.getQueryId(ref);
            if (id != null) {
                this.conditionQueryRefs.put(id, query);
                this.addMonitorQuery(id, query);
            }
        } else {
            this.context.ungetService(ref);
        }
    }

    private void checkAddEventQuery(ServiceReference<?> ref) {
        logger.info("Checking query: " + ref);
        Object o = this.context.getService(ref);
        if (o instanceof EventQuery) {
            EventQuery query = (EventQuery)o;
            String id = this.getQueryId(ref);
            if (id != null) {
                this.eventQueryRefs.put(id, query);
                this.addEventQuery(id, query);
            }
        } else {
            this.context.ungetService(ref);
        }
    }

    private String getQueryId(ServiceReference<?> ref) {
        Object p = ref.getProperty("service.pid");
        if (p != null) {
            return p.toString();
        }
        return null;
    }
}

