/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.datasource.item;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.core.AttributesHelper;
import org.eclipse.scada.core.InvalidOperationException;
import org.eclipse.scada.core.OperationException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.core.DataItemInformation;
import org.eclipse.scada.da.core.WriteAttributeResults;
import org.eclipse.scada.da.core.WriteResult;
import org.eclipse.scada.da.datasource.DataSource;
import org.eclipse.scada.da.datasource.DataSourceListener;
import org.eclipse.scada.da.datasource.SingleDataSourceTracker;
import org.eclipse.scada.da.server.common.DataItemBase;
import org.eclipse.scada.utils.concurrent.InstantErrorFuture;
import org.eclipse.scada.utils.concurrent.InstantFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.osgi.framework.InvalidSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataItemTargetImpl
extends DataItemBase
implements DataSourceListener {
    private static final Logger logger = LoggerFactory.getLogger(DataItemTargetImpl.class);
    private DataItemValue currentValue = DataItemValue.DISCONNECTED;
    private final SingleDataSourceTracker tracker;
    private DataSource dataSource;

    public DataItemTargetImpl(ObjectPoolTracker<DataSource> poolTracker, DataItemInformation information, String dataSourceId) throws InvalidSyntaxException {
        super(information);
        this.tracker = new SingleDataSourceTracker(poolTracker, dataSourceId, new SingleDataSourceTracker.ServiceListener(){

            public void dataSourceChanged(DataSource dataSource) {
                DataItemTargetImpl.this.setDataSource(dataSource);
            }
        });
        this.tracker.open();
    }

    protected synchronized Map<String, Variant> getCacheAttributes() {
        DataItemValue value = this.currentValue;
        if (value != null) {
            return value.getAttributes();
        }
        return null;
    }

    protected synchronized Variant getCacheValue() {
        DataItemValue value = this.currentValue;
        if (value != null) {
            return value.getValue();
        }
        return null;
    }

    protected synchronized void setDataSource(DataSource dataSource) {
        logger.info("Setting datasource: {}", (Object)dataSource);
        this.disconnectDatasource();
        this.connectDataSource(dataSource);
    }

    private synchronized void connectDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        if (this.dataSource != null) {
            this.dataSource.addListener((DataSourceListener)this);
        }
    }

    private synchronized void disconnectDatasource() {
        if (this.dataSource != null) {
            this.dataSource.removeListener((DataSourceListener)this);
            this.dataSource = null;
            this.stateChanged(null);
        }
    }

    public synchronized Map<String, Variant> getAttributes() {
        return Collections.unmodifiableMap(this.currentValue.getAttributes());
    }

    public synchronized NotifyFuture<Variant> readValue() throws InvalidOperationException {
        return new InstantFuture((Object)this.currentValue.getValue());
    }

    public synchronized NotifyFuture<WriteAttributeResults> startSetAttributes(Map<String, Variant> attributes, OperationParameters operationParameters) {
        if (this.dataSource != null) {
            return this.dataSource.startWriteAttributes(attributes, operationParameters);
        }
        return new InstantErrorFuture((Throwable)new OperationException("Disconnected data source"));
    }

    public synchronized NotifyFuture<WriteResult> startWriteValue(Variant value, OperationParameters operationParameters) {
        if (this.dataSource != null) {
            return this.dataSource.startWriteValue(value, operationParameters);
        }
        return new InstantErrorFuture((Throwable)new OperationException("Disconnected data source"));
    }

    public synchronized void dispose() {
        if (this.tracker != null) {
            this.tracker.close();
        }
    }

    public synchronized void stateChanged(DataItemValue value) {
        logger.debug("State changed: {}", (Object)value);
        if (value == null) {
            this.currentValue = value;
            this.notifyData(Variant.NULL, new HashMap(1), true);
        } else {
            if (this.currentValue == null) {
                this.currentValue = DataItemValue.DISCONNECTED;
            }
            HashMap target = new HashMap(this.currentValue.getAttributes());
            HashMap diff = new HashMap();
            AttributesHelper.set(target, (Map)value.getAttributes(), diff);
            Variant oldValue = Variant.valueOf((Object)this.currentValue.getValue());
            Variant newValue = Variant.valueOf((Object)value.getValue());
            this.currentValue = value;
            if (!diff.isEmpty() || !oldValue.equals((Object)newValue)) {
                this.notifyData(value.getValue(), diff);
            }
        }
    }
}

