/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.scada.da.server.common.item.factory.DefaultChainItemFactory;
import org.eclipse.scada.da.server.common.item.factory.FolderItemFactory;
import org.eclipse.scada.da.server.jdbc.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractQuery {
    private static final Logger logger = LoggerFactory.getLogger(AbstractQuery.class);
    private final String id;
    private final int period;
    protected final String sql;
    protected final Connection connection;
    private ScheduledExecutorService timer;
    private final Runnable task;
    protected FolderItemFactory itemFactory;
    protected final Map<Integer, String> columnAliases;
    private ScheduledFuture<?> job;

    public AbstractQuery(String id, int period, String sql, Connection connection, Map<Integer, String> columnAliases) {
        this.id = id;
        this.period = period;
        this.sql = sql;
        this.connection = connection;
        this.columnAliases = columnAliases;
        logger.info("Created new query: {}", (Object)this.id);
        this.task = new Runnable(){

            @Override
            public void run() {
                AbstractQuery.this.tick();
            }
        };
    }

    public void register(ScheduledExecutorService timer, DefaultChainItemFactory parentItemFactory) {
        this.timer = timer;
        this.itemFactory = parentItemFactory.createSubFolderFactory(this.id);
        this.job = this.timer.scheduleAtFixedRate(this.task, 0L, this.period, TimeUnit.MILLISECONDS);
    }

    public void unregister() {
        if (this.job != null) {
            this.job.cancel(false);
            this.job = null;
        }
        this.timer = null;
        if (this.itemFactory != null) {
            this.itemFactory.dispose();
            this.itemFactory = null;
        }
    }

    public void tick() {
        try {
            this.doQuery();
        }
        catch (Throwable e) {
            logger.debug("Global error", e);
            this.setGlobalError(e);
        }
    }

    protected abstract void setGlobalError(Throwable var1);

    protected abstract void doQuery() throws Exception;

    protected String mapFieldName(int i, ResultSet result) throws SQLException {
        String field = this.columnAliases.containsKey(i) ? this.columnAliases.get(i) : result.getMetaData().getColumnName(i);
        return field;
    }
}

