/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.monitor.proxy;

import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.eclipse.scada.ae.data.MonitorStatusInformation;
import org.eclipse.scada.ae.server.common.monitor.MonitorQuery;
import org.eclipse.scada.ae.server.common.monitor.MonitorQueryListener;
import org.eclipse.scada.ae.server.monitor.proxy.AbstractMonitorQueryListener;
import org.eclipse.scada.ae.server.monitor.proxy.ProxyMonitorQuery;
import org.eclipse.scada.utils.osgi.FilterUtil;
import org.eclipse.scada.utils.osgi.SingleServiceListener;
import org.eclipse.scada.utils.osgi.SingleServiceTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LocalMonitorQueryListener
extends AbstractMonitorQueryListener {
    private static final Logger logger = LoggerFactory.getLogger(LocalMonitorQueryListener.class);
    private final SingleServiceTracker<MonitorQuery> tracker;
    private MonitorQuery service;
    private final SingleServiceListener<MonitorQuery> queryListener = new SingleServiceListener<MonitorQuery>(){

        public void serviceChange(ServiceReference<MonitorQuery> reference, MonitorQuery service) {
            LocalMonitorQueryListener.this.setQueryService(service);
        }
    };
    private final MonitorQueryListener monitorQueryListener = new MonitorQueryListener(){

        public void dataChanged(List<MonitorStatusInformation> addedOrUpdated, Set<String> removed, boolean full) {
            LocalMonitorQueryListener.this.handleDataChanged(addedOrUpdated, removed, full);
        }
    };

    public LocalMonitorQueryListener(BundleContext context, String monitorQueryId, ProxyMonitorQuery proxyMonitorQuery, Lock lock) throws InvalidSyntaxException {
        super(proxyMonitorQuery, lock, monitorQueryId);
        logger.info("Creating new listener - query: {}", (Object)monitorQueryId);
        this.tracker = new SingleServiceTracker(context, FilterUtil.createClassAndPidFilter(MonitorQuery.class, (String)monitorQueryId), this.queryListener);
        this.tracker.open();
    }

    @Override
    public void dispose() {
        this.tracker.close();
        super.dispose();
    }

    protected void setQueryService(MonitorQuery service) {
        this.lock.lock();
        try {
            if (service == this.service) {
                return;
            }
            if (this.service != null) {
                this.service.removeListener(this.monitorQueryListener);
                this.clearAll();
            }
            this.service = service;
            if (this.service != null) {
                service.addListener(this.monitorQueryListener);
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

