/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.subscription;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.scada.core.subscription.Subscription;
import org.eclipse.scada.core.subscription.SubscriptionListener;
import org.eclipse.scada.core.subscription.SubscriptionSource;
import org.eclipse.scada.core.subscription.SubscriptionValidator;
import org.eclipse.scada.core.subscription.ValidationException;

public class SubscriptionManager {
    private final Map<Object, Subscription> subscriptions = new HashMap<Object, Subscription>();
    private SubscriptionValidator validator = null;

    public synchronized void unsubscribeAll(SubscriptionListener listener) {
        Iterator<Map.Entry<Object, Subscription>> i = this.subscriptions.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Object, Subscription> entry = i.next();
            entry.getValue().unsubscribe(listener);
            if (!entry.getValue().isEmpty()) continue;
            i.remove();
        }
    }

    public synchronized void subscribe(Object topic, SubscriptionListener listener) throws ValidationException {
        this.subscribe(topic, listener, null);
    }

    public synchronized void subscribe(Object topic, SubscriptionListener listener, Object hint) throws ValidationException {
        SubscriptionValidator v = this.validator;
        if (v != null && !v.validate(listener, topic)) {
            throw new ValidationException();
        }
        Subscription s = this.subscriptions.get(topic);
        if (s == null) {
            s = new Subscription(topic);
            this.subscriptions.put(topic, s);
        }
        s.subscribe(listener, hint);
    }

    public synchronized void unsubscribe(Object topic, SubscriptionListener listener) {
        Subscription s = this.subscriptions.get(topic);
        if (s == null) {
            return;
        }
        s.unsubscribe(listener);
        if (s.isEmpty()) {
            this.subscriptions.remove(topic);
        }
    }

    public void setValidator(SubscriptionValidator validator) {
        this.validator = validator;
    }

    public synchronized void setSource(Object topic, SubscriptionSource source) {
        Subscription s = this.subscriptions.get(topic);
        if (s == null && source == null) {
            return;
        }
        if (s == null) {
            s = new Subscription(topic);
            this.subscriptions.put(topic, s);
        }
        s.setSource(source);
        if (s.isEmpty()) {
            this.subscriptions.remove(topic);
        }
    }

    public int getSubscriptionCount() {
        return this.subscriptions.size();
    }

    public synchronized List<Object> getAllGrantedTopics() {
        LinkedList<Object> topicList = new LinkedList<Object>();
        for (Map.Entry<Object, Subscription> entry : this.subscriptions.entrySet()) {
            if (!entry.getValue().isGranted()) continue;
            topicList.add(entry.getKey());
        }
        return topicList;
    }
}

