/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.client.ngp;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import org.eclipse.scada.ae.Query;
import org.eclipse.scada.ae.QueryListener;
import org.eclipse.scada.ae.client.ngp.ConnectionImpl;
import org.eclipse.scada.ae.client.ngp.Events;
import org.eclipse.scada.ae.client.ngp.QueryImpl;
import org.eclipse.scada.ae.data.EventInformation;
import org.eclipse.scada.ae.data.QueryState;
import org.eclipse.scada.core.OperationException;
import org.eclipse.scada.core.data.ErrorInformation;

public class QueryManager {
    private final ExecutorService executor;
    private final ConnectionImpl connection;
    private final Map<Long, QueryImpl> queries = new HashMap<Long, QueryImpl>();
    private final Random r = new Random();

    public QueryManager(ExecutorService executor, ConnectionImpl connection) {
        this.executor = executor;
        this.connection = connection;
    }

    public void dispose() {
        this.onClosed();
    }

    public void onClosed() {
        for (QueryImpl query : this.queries.values()) {
            query.dispose();
        }
        this.queries.clear();
    }

    public void onBound() {
    }

    public Query createQuery(String queryType, String queryData, QueryListener listener) {
        long queryId = this.nextId();
        QueryImpl query = new QueryImpl(this.executor, this.connection, queryId, listener);
        this.queries.put(queryId, query);
        this.connection.sendCreateQuery(queryId, queryType, queryData);
        return query;
    }

    private long nextId() {
        long id;
        while (this.queries.containsKey(id = this.r.nextLong())) {
        }
        return id;
    }

    public void updateQueryState(long queryId, QueryState state, ErrorInformation error) {
        QueryImpl query = this.queries.get(queryId);
        if (query == null) {
            return;
        }
        if (state == QueryState.DISCONNECTED) {
            query.dispose();
            this.queries.remove(queryId);
        } else {
            query.handleStateChange(query.getListener(), state, error == null ? null : new OperationException(error.getMessage()).fillInStackTrace());
        }
    }

    public void updateQueryData(long queryId, List<EventInformation> events) {
        QueryImpl query = this.queries.get(queryId);
        if (query == null) {
            return;
        }
        query.handleData(query.getListener(), Events.convertToEvent(events));
    }
}

