/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common;

import java.util.EnumSet;
import java.util.Map;
import org.eclipse.scada.core.InvalidOperationException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.da.core.WriteAttributeResult;
import org.eclipse.scada.da.core.WriteAttributeResults;
import org.eclipse.scada.da.core.WriteResult;
import org.eclipse.scada.da.data.IODirection;
import org.eclipse.scada.da.server.common.AttributeManager;
import org.eclipse.scada.da.server.common.DataItemBase;
import org.eclipse.scada.da.server.common.DataItemInformationBase;
import org.eclipse.scada.utils.concurrent.InstantFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;

public class MemoryDataItem
extends DataItemBase {
    private volatile Variant value = Variant.NULL;
    private AttributeManager attributes = new AttributeManager(this);

    public MemoryDataItem(String name) {
        this(name, EnumSet.of(IODirection.INPUT, IODirection.OUTPUT));
    }

    protected MemoryDataItem(String name, EnumSet<IODirection> ioDirection) {
        super(new DataItemInformationBase(name, ioDirection));
    }

    @Override
    public NotifyFuture<Variant> readValue() throws InvalidOperationException {
        return new InstantFuture((Object)this.value);
    }

    @Override
    public NotifyFuture<WriteResult> startWriteValue(Variant value, OperationParameters operationParameters) {
        if (!this.value.equals((Object)value)) {
            this.value = value;
            this.notifyData(value, null);
        }
        return new InstantFuture((Object)new WriteResult());
    }

    @Override
    public Map<String, Variant> getAttributes() {
        return this.attributes.get();
    }

    @Override
    protected Map<String, Variant> getCacheAttributes() {
        return this.attributes.get();
    }

    @Override
    protected Variant getCacheValue() {
        return this.value;
    }

    @Override
    public NotifyFuture<WriteAttributeResults> startSetAttributes(Map<String, Variant> attributes, OperationParameters operationParameters) {
        WriteAttributeResults writeAttributeResults = new WriteAttributeResults();
        this.attributes.update(null, attributes);
        for (Map.Entry<String, Variant> entry : attributes.entrySet()) {
            writeAttributeResults.put((Object)entry.getKey(), (Object)WriteAttributeResult.OK);
        }
        return new InstantFuture((Object)writeAttributeResults);
    }
}

