/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common.memory;

import java.util.Map;
import org.apache.mina.core.buffer.IoBuffer;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.server.common.memory.AbstractAttribute;
import org.eclipse.scada.da.server.common.memory.Attribute;
import org.eclipse.scada.da.server.common.memory.MemoryRequestBlock;

public class ByteAttribute
extends AbstractAttribute
implements Attribute {
    private final int index;
    private Byte lastValue;
    private Variant lastTimestamp;
    private final boolean enableTimestamp;

    public ByteAttribute(String name, int index, boolean enableTimestamp) {
        super(name);
        this.index = index;
        this.enableTimestamp = enableTimestamp;
    }

    @Override
    public void handleData(IoBuffer data, Map<String, Variant> attributes, Variant timestamp) {
        byte b = data.get(this.toAddress(this.index));
        attributes.put(this.name, Variant.valueOf((int)b));
        if (!Byte.valueOf(b).equals(this.lastValue)) {
            this.lastValue = b;
            this.lastTimestamp = timestamp;
        }
        if (this.enableTimestamp) {
            attributes.put(String.valueOf(this.name) + ".timestamp", this.lastTimestamp);
        }
    }

    @Override
    public void handleError(Map<String, Variant> attributes) {
        this.lastValue = null;
        this.lastTimestamp = null;
    }

    @Override
    public void handleWrite(Variant value) {
        MemoryRequestBlock block = this.block;
        if (block == null) {
            throw new IllegalStateException("Device is not connected");
        }
        Integer i = value.asInteger(null);
        if (i != null) {
            block.writeData(this.toAddress(this.index), new byte[]{i.byteValue()});
        }
    }
}

