/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.client.sfp;

import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.logging.LoggingFilter;
import org.eclipse.scada.protocol.common.IoLoggerFilterChainBuilder;
import org.eclipse.scada.protocol.common.StatisticsFilter;
import org.eclipse.scada.protocol.sfp.ProtocolDecoderImpl;
import org.eclipse.scada.protocol.sfp.ProtocolEncoderImpl;

public class FilterChainBuilder
implements IoLoggerFilterChainBuilder {
    private String loggerName;

    public void setLoggerName(String loggerName) {
        this.loggerName = loggerName;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public void buildFilterChain(IoFilterChain chain) {
        if (this.loggerName != null && Boolean.getBoolean("org.eclipse.scada.protocol.sfp.common.logger.raw")) {
            chain.addFirst("logger.raw", (IoFilter)new LoggingFilter(this.loggerName));
        }
        if (!Boolean.getBoolean("org.eclipse.scada.protocol.sfp.common.disableStats")) {
            chain.addFirst("core.stats", (IoFilter)new StatisticsFilter());
        }
        if (this.loggerName != null && Boolean.getBoolean("org.eclipse.scada.protocol.sfp.common.logger")) {
            chain.addFirst("logger", (IoFilter)new LoggingFilter(this.loggerName));
        }
        chain.addLast("closeidle", (IoFilter)new IoFilterAdapter(){

            public void sessionIdle(IoFilter.NextFilter nextFilter, IoSession session, IdleStatus status) throws Exception {
                session.close(true);
            }
        });
        chain.addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolEncoder)new ProtocolEncoderImpl(), (ProtocolDecoder)new ProtocolDecoderImpl()));
    }
}

