/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.client.sfp.strategy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.data.SubscriptionState;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.client.FolderListener;
import org.eclipse.scada.da.client.ItemUpdateListener;
import org.eclipse.scada.da.client.sfp.ConnectionHandler;
import org.eclipse.scada.da.client.sfp.strategy.DataManager;
import org.eclipse.scada.da.client.sfp.strategy.FolderManager;
import org.eclipse.scada.da.client.sfp.strategy.WriteHandler;
import org.eclipse.scada.da.core.Location;
import org.eclipse.scada.protocol.sfp.messages.BrowseUpdate;
import org.eclipse.scada.protocol.sfp.messages.DataUpdate;
import org.eclipse.scada.protocol.sfp.messages.ReadAll;
import org.eclipse.scada.protocol.sfp.messages.SubscribeBrowse;
import org.eclipse.scada.protocol.sfp.messages.WriteCommand;
import org.eclipse.scada.protocol.sfp.messages.WriteResult;
import org.eclipse.scada.utils.concurrent.InstantErrorFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadAllStrategy {
    private static final Logger logger = LoggerFactory.getLogger(ReadAllStrategy.class);
    private final ConnectionHandler connectionHandler;
    private ScheduledFuture<?> pollJob;
    private Set<Integer> previousRegisters = new HashSet<Integer>();
    private final DataManager dataManager;
    private final FolderManager folderManager;
    private final long pollDelay;
    private final Random random = new Random();
    private final Map<Integer, WriteHandler> writeHandlerMap = new HashMap<Integer, WriteHandler>();

    public ReadAllStrategy(ConnectionHandler connectionHandler, long pollDelay) {
        logger.debug("Created new strategy");
        this.pollDelay = pollDelay;
        this.connectionHandler = connectionHandler;
        this.dataManager = new DataManager(connectionHandler);
        this.folderManager = new FolderManager(connectionHandler);
        this.connectionHandler.sendMessage(new SubscribeBrowse());
    }

    protected void triggerReadAll() {
        this.connectionHandler.sendMessage(new ReadAll());
    }

    public void handleMessage(Object message) {
        if (message instanceof DataUpdate) {
            this.processDataUpdate((DataUpdate)message);
        } else if (message instanceof BrowseUpdate) {
            this.processBrowseUpdate((BrowseUpdate)message);
        } else if (message instanceof WriteResult) {
            this.processWriteResult((WriteResult)message);
        }
    }

    private void processWriteResult(final WriteResult message) {
        logger.debug("Processing write result");
        final WriteHandler handler = this.writeHandlerMap.remove(message.getOperationId());
        if (handler == null) {
            logger.warn("No handler found for operation: {}", (Object)message.getOperationId());
            return;
        }
        this.execute(new Runnable(){

            @Override
            public void run() {
                handler.complete(message);
            }
        });
    }

    private void processBrowseUpdate(BrowseUpdate message) {
        logger.debug("Browse data update:");
        for (BrowseUpdate.Entry entry : message.getEntries()) {
            logger.trace("\t{} = '{}'", (Object)entry.getRegister(), (Object)entry.getName());
        }
        for (BrowseUpdate.Entry entry : message.getEntries()) {
            this.dataManager.addMapping(entry.getRegister(), entry.getName(), entry.getUnit());
            String[] toks = this.makeItemHiearchy(entry.getName());
            LinkedList<String> hier = new LinkedList<String>(Arrays.asList(toks));
            if (hier.size() == 1) {
                this.folderManager.addEntry(new Location(), entry.getName(), entry.getName(), entry.getDescription());
                continue;
            }
            String name = hier.removeLast();
            this.folderManager.addEntry(new Location(hier), name, entry.getName(), entry.getDescription());
        }
        if (this.pollJob == null) {
            this.pollJob = this.connectionHandler.getExecutor().scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    ReadAllStrategy.this.triggerReadAll();
                }
            }, 0L, this.pollDelay, TimeUnit.MILLISECONDS);
        }
    }

    private String[] makeItemHiearchy(String name) {
        return name.split("\\.");
    }

    private void processDataUpdate(DataUpdate message) {
        HashSet<Integer> registers = new HashSet<Integer>();
        for (DataUpdate.Entry entry : message.getEntries()) {
            DataItemValue value = ReadAllStrategy.convert(entry);
            this.dataManager.updateData(entry.getRegister(), value);
            registers.add(entry.getRegister());
        }
        this.previousRegisters.removeAll(registers);
        for (Integer removed : this.previousRegisters) {
            this.dataManager.removeRegister(removed);
        }
        this.previousRegisters = registers;
    }

    private static DataItemValue convert(DataUpdate.Entry entry) {
        HashMap<String, Variant> attributes = new HashMap<String, Variant>(10);
        attributes.put("timestamp", Variant.valueOf((long)entry.getTimestamp()));
        attributes.put("sfp.register", Variant.valueOf((int)entry.getRegister()));
        attributes.put("error", Variant.valueOf((boolean)entry.getStates().contains(DataUpdate.State.ERROR)));
        attributes.put("alarm", Variant.valueOf((boolean)entry.getStates().contains(DataUpdate.State.ALARM)));
        attributes.put("warning", Variant.valueOf((boolean)entry.getStates().contains(DataUpdate.State.WARNING)));
        attributes.put("error.ackRequired", Variant.valueOf((boolean)entry.getStates().contains(DataUpdate.State.ERROR_ACK)));
        attributes.put("alarm.ackRequired", Variant.valueOf((boolean)entry.getStates().contains(DataUpdate.State.ALARM_ACK)));
        attributes.put("warning.ackRequired", Variant.valueOf((boolean)entry.getStates().contains(DataUpdate.State.WARNING_ACK)));
        attributes.put("manual", Variant.valueOf((boolean)entry.getStates().contains(DataUpdate.State.MANUAL_OVERRIDE)));
        attributes.put("blocked", Variant.valueOf((boolean)entry.getStates().contains(DataUpdate.State.BLOCKED)));
        return new DataItemValue(entry.getValue(), attributes, SubscriptionState.CONNECTED);
    }

    public void dispose() {
        if (this.pollJob != null) {
            this.pollJob.cancel(false);
            this.pollJob = null;
        }
        if (!this.writeHandlerMap.isEmpty()) {
            final ArrayList<WriteHandler> handlers = new ArrayList<WriteHandler>(this.writeHandlerMap.values());
            this.execute(new Runnable(){

                @Override
                public void run() {
                    for (WriteHandler handler : handlers) {
                        handler.cancel(false);
                    }
                }
            });
            this.writeHandlerMap.clear();
        }
        this.folderManager.dispose();
        this.dataManager.dispose();
    }

    public void subscribeItem(String itemId) {
        logger.debug("Subscribe item: {}", (Object)itemId);
        this.dataManager.subscribeItem(itemId);
    }

    public void unsubscribeItem(String itemId) {
        logger.debug("Unsubscribe item: {}", (Object)itemId);
        this.dataManager.unsubscribeItem(itemId);
    }

    public void setItemUpateListener(String itemId, ItemUpdateListener listener) {
        this.dataManager.setItemUpateListener(itemId, listener);
    }

    public void setAllItemListeners(Map<String, ItemUpdateListener> itemListeners) {
        this.dataManager.setAllItemListeners(itemListeners);
    }

    protected void execute(Runnable command) {
        this.connectionHandler.getExecutor().execute(command);
    }

    public void subscribeFolder(Location location) {
        this.folderManager.subscribeFolder(location);
    }

    public void unsubscribeFolder(Location location) {
        this.folderManager.unsubscribeFolder(location);
    }

    public void setFolderListener(Location location, FolderListener listener) {
        this.folderManager.setFolderListener(location, listener);
    }

    public void setAllFolderListeners(Map<Location, FolderListener> folderListeners) {
        for (Map.Entry<Location, FolderListener> entry : folderListeners.entrySet()) {
            this.setFolderListener(entry.getKey(), entry.getValue());
        }
    }

    public NotifyFuture<org.eclipse.scada.da.core.WriteResult> startWrite(String itemId, Variant value) {
        int operationId;
        while (this.writeHandlerMap.containsKey(operationId = this.random.nextInt())) {
        }
        WriteHandler writeHandler = new WriteHandler();
        Integer registerNumber = this.dataManager.findRegister(itemId);
        if (registerNumber == null) {
            return new InstantErrorFuture((Throwable)new RuntimeException(String.format("Item '%s' is unknown", itemId)));
        }
        this.connectionHandler.sendMessage(new WriteCommand(registerNumber.intValue(), value, operationId));
        this.writeHandlerMap.put(operationId, writeHandler);
        return writeHandler;
    }
}

