/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.authz.signature;

import java.security.Key;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.LinkedList;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class RequestSigner {
    private final XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
    private final DigestMethod md;
    private final KeyInfoFactory kif;
    private final Transform t;
    private final Reference ref;
    private final CanonicalizationMethod cm;

    private String fromAlg(String alg) {
        if ("DSA".equals(alg)) {
            return "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
        }
        if ("RSA".equals(alg)) {
            return "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        }
        if ("HMAC".equals(alg)) {
            return "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
        }
        throw new IllegalArgumentException(String.format("Key algorithm '%s' is not supported", alg));
    }

    public RequestSigner(Configuration configuration) throws Exception {
        this.md = this.fac.newDigestMethod(configuration.getDigestMethod(), null);
        this.kif = this.fac.getKeyInfoFactory();
        this.t = this.fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null);
        this.ref = this.fac.newReference("", this.md, Collections.singletonList(this.t), null, null);
        this.cm = this.fac.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (C14NMethodParameterSpec)null);
    }

    public void sign(Key privateKey, Certificate cert, Document doc) throws Exception {
        this.sign(privateKey, null, cert, doc);
    }

    public synchronized void sign(KeyPair kp, Document doc) throws Exception {
        this.sign(kp.getPrivate(), kp.getPublic(), null, doc);
    }

    synchronized void sign(Key privateKey, PublicKey publicKey, Certificate cert, Document doc) throws Exception {
        DOMSignContext dsc = new DOMSignContext(privateKey, (Node)doc.getDocumentElement());
        SignatureMethod sm = this.fac.newSignatureMethod(this.fromAlg(privateKey.getAlgorithm()), null);
        SignedInfo si = this.fac.newSignedInfo(this.cm, sm, Collections.singletonList(this.ref));
        LinkedList<XMLStructure> data = new LinkedList<XMLStructure>();
        if (cert != null) {
            data.add(this.kif.newKeyValue(cert.getPublicKey()));
            data.add(this.kif.newX509Data(Collections.singletonList(cert)));
        } else {
            data.add(this.kif.newKeyValue(publicKey));
        }
        KeyInfo ki = this.kif.newKeyInfo(data);
        XMLSignature signature = this.fac.newXMLSignature(si, ki);
        signature.sign(dsc);
    }

    public static class Configuration {
        private String digestMethod = "http://www.w3.org/2000/09/xmldsig#sha1";

        public void setDigestMethod(String digestMethod) {
            this.digestMethod = digestMethod;
        }

        public String getDigestMethod() {
            return this.digestMethod;
        }
    }
}

