/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.monitor.datasource.common.remote;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.scada.ae.data.MonitorStatus;
import org.eclipse.scada.ae.event.EventProcessor;
import org.eclipse.scada.ae.monitor.common.DataItemMonitor;
import org.eclipse.scada.ae.monitor.datasource.common.remote.GenericRemoteMonitor;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.VariantEditor;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.master.MasterItem;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteBooleanValueAlarmMonitor
extends GenericRemoteMonitor
implements DataItemMonitor {
    static final Logger logger = LoggerFactory.getLogger(RemoteBooleanValueAlarmMonitor.class);
    public static final String FACTORY_ID = "ae.monitor.da.remote.booleanValueAlarm";
    private String attributeAck;
    private String attributeActive;
    private String attributeAckTimestamp;
    private Variant aknValue = Variant.TRUE;

    public RemoteBooleanValueAlarmMonitor(BundleContext context, Executor executor, ObjectPoolTracker<MasterItem> poolTracker, EventProcessor eventProcessor, String id, int priority) {
        super(context, executor, poolTracker, priority, id, eventProcessor);
    }

    @Override
    protected void handleUpdate(DataItemValue.Builder builder) {
        MonitorStatus state;
        logger.debug("Perform update");
        Variant value = builder.getValue();
        Variant ack = (Variant)builder.getAttributes().get(this.attributeAck);
        Variant active = (Variant)builder.getAttributes().get(this.attributeActive);
        Calendar timestamp = builder.getTimestamp();
        if (timestamp == null) {
            timestamp = Calendar.getInstance();
        }
        Calendar aknTimestamp = RemoteBooleanValueAlarmMonitor.getTimestamp(builder, this.attributeAckTimestamp);
        if (value == null) {
            this.setState(MonitorStatus.UNSAFE);
            this.injectState(builder);
            return;
        }
        boolean alarmFlag = value.asBoolean();
        boolean activeFlag = active == null ? true : active.asBoolean();
        if (!activeFlag) {
            state = MonitorStatus.INACTIVE;
        } else if (ack == null) {
            state = alarmFlag ? MonitorStatus.NOT_OK : MonitorStatus.OK;
        } else {
            boolean ackRequiredFlag = ack.asBoolean();
            state = alarmFlag ? (ackRequiredFlag ? MonitorStatus.NOT_OK_NOT_AKN : MonitorStatus.NOT_OK_AKN) : (ackRequiredFlag ? MonitorStatus.NOT_AKN : MonitorStatus.OK);
        }
        this.setState(state, timestamp.getTime(), aknTimestamp.getTime());
        this.injectState(builder);
    }

    public void akn(UserInformation userInformation, Date aknTimestamp) {
        this.publishAckRequestEvent(userInformation, aknTimestamp);
        HashMap<String, Variant> attributes = new HashMap<String, Variant>();
        attributes.put(this.attributeAck, this.aknValue);
        for (MasterItem item : this.getMasterItems()) {
            item.startWriteAttributes(attributes, new OperationParameters(userInformation, null, null));
        }
    }

    public void setActive(UserInformation userInformation, boolean state) {
        HashMap<String, Variant> attributes = new HashMap<String, Variant>();
        attributes.put(this.attributeActive, state ? Variant.TRUE : Variant.FALSE);
        for (MasterItem item : this.getMasterItems()) {
            item.startWriteAttributes(attributes, new OperationParameters(userInformation, null, null));
        }
    }

    public synchronized void update(UserInformation userInformation, Map<String, String> parameters) throws Exception {
        logger.debug("Apply update: {}", parameters);
        super.update(userInformation, parameters);
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(parameters);
        this.attributeAck = cfg.getString("attribute.ack.name");
        this.attributeActive = cfg.getString("attribute.active.name");
        this.attributeAckTimestamp = cfg.getStringNonEmpty("attribute.ack.timestamp.name");
        VariantEditor ve = new VariantEditor();
        ve.setAsText(cfg.getString("attribute.ack.value", "BOOL#true"));
        this.aknValue = (Variant)ve.getValue();
        this.reprocess();
        logger.debug("Done applying");
    }
}

