/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common.osgi.factory;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.core.DataItemInformation;
import org.eclipse.scada.da.data.IODirection;
import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.da.server.common.DataItemCommand;
import org.eclipse.scada.da.server.common.DataItemInformationBase;
import org.eclipse.scada.da.server.common.chain.DataItemInputChained;
import org.eclipse.scada.da.server.common.chain.WriteHandler;
import org.eclipse.scada.da.server.common.chain.WriteHandlerItem;
import org.eclipse.scada.da.server.common.item.factory.ItemFactory;
import org.eclipse.scada.utils.osgi.pool.ManageableObjectPool;

public class ObjectPoolDataItemFactory
implements ItemFactory {
    private final ManageableObjectPool<DataItem> objectPool;
    private final Executor executor;
    private final String prefix;
    private final Map<String, DataItem> items = new HashMap<String, DataItem>();

    public ObjectPoolDataItemFactory(Executor executor, ManageableObjectPool<DataItem> objectPool, String prefix) {
        this.executor = executor;
        this.objectPool = objectPool;
        this.prefix = prefix;
    }

    protected String getId(String localId) {
        if (this.prefix == null) {
            return localId;
        }
        return String.valueOf(this.prefix) + localId;
    }

    public synchronized DataItemCommand createCommand(String localId, Map<String, Variant> properties) {
        return this.registerItem(new DataItemCommand(this.getId(localId), this.executor), properties);
    }

    public synchronized DataItemInputChained createInput(String localId, Map<String, Variant> properties) {
        return this.registerItem(new DataItemInputChained(this.getId(localId), this.executor), properties);
    }

    public synchronized WriteHandlerItem createInputOutput(String localId, Map<String, Variant> properties, WriteHandler writeHandler) {
        return this.registerItem(new WriteHandlerItem(this.getId(localId), writeHandler, this.executor), properties);
    }

    public WriteHandlerItem createOutput(String localId, Map<String, Variant> properties, WriteHandler writeHandler) {
        return this.registerItem(new WriteHandlerItem((DataItemInformation)new DataItemInformationBase(this.getId(localId), EnumSet.of(IODirection.OUTPUT)), writeHandler, this.executor), properties);
    }

    private <T extends DataItem> T registerItem(T item, Map<String, Variant> properties) {
        Hashtable localProperties = new Hashtable(0);
        String itemId = item.getInformation().getName();
        DataItem oldItem = this.items.remove(itemId);
        if (oldItem != null) {
            this.objectPool.removeService(itemId, (Object)oldItem);
        }
        this.items.put(itemId, item);
        this.objectPool.addService(itemId, item, localProperties);
        return item;
    }

    protected void unregisterItem(DataItem dataItem) {
        this.objectPool.removeService(dataItem.getInformation().getName(), (Object)dataItem);
    }

    public synchronized void dispose() {
        this.disposeAllItems();
    }

    public synchronized void disposeAllItems() {
        for (Map.Entry<String, DataItem> entry : this.items.entrySet()) {
            this.unregisterItem(entry.getValue());
        }
        this.items.clear();
    }

    public synchronized void disposeItem(DataItem dataItem) {
        String itemId = dataItem.getInformation().getName();
        if (this.items.get(itemId) != dataItem) {
            return;
        }
        this.items.remove(itemId);
        this.unregisterItem(dataItem);
    }
}

