/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.common.event.pool.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.eclipse.scada.ae.event.EventManager;
import org.eclipse.scada.ae.server.common.event.EventQuery;
import org.eclipse.scada.ae.server.common.event.pool.internal.EventPoolImpl;
import org.eclipse.scada.ae.server.storage.Storage;
import org.eclipse.scada.utils.concurrent.NamedThreadFactory;
import org.eclipse.scada.utils.osgi.FilterUtil;
import org.eclipse.scada.utils.osgi.SingleServiceListener;
import org.eclipse.scada.utils.osgi.SingleServiceTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventPoolManager {
    private static final Logger logger = LoggerFactory.getLogger(EventPoolManager.class);
    private final BundleContext context;
    private final SingleServiceTracker<?> eventManagerTracker;
    private final SingleServiceTracker<?> storageTracker;
    private Storage storage;
    private EventManager eventManager;
    private EventPoolImpl pool;
    private ServiceRegistration<?> poolHandle;
    private final String id;
    private final ExecutorService executor;
    private String filter;
    private int size;

    public EventPoolManager(BundleContext context, String id, String filter, int size) throws InvalidSyntaxException {
        this.context = context;
        this.id = id;
        this.filter = filter;
        this.size = size;
        this.executor = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("EventPoolManager/" + id));
        this.eventManagerTracker = new SingleServiceTracker(this.context, FilterUtil.createClassFilter((String)EventManager.class.getName()), (SingleServiceListener)new SingleServiceListener<Object>(){

            public void serviceChange(ServiceReference<Object> reference, Object service) {
                EventPoolManager.this.setEventManager((EventManager)service);
            }
        });
        this.eventManagerTracker.open();
        this.storageTracker = new SingleServiceTracker(this.context, FilterUtil.createClassFilter((String)Storage.class.getName()), (SingleServiceListener)new SingleServiceListener<Object>(){

            public void serviceChange(ServiceReference<Object> reference, Object service) {
                EventPoolManager.this.setStorageService((Storage)service);
            }
        });
        this.storageTracker.open();
    }

    protected synchronized void setStorageService(Storage service) {
        logger.debug("Setting storage service: {}", (Object)service);
        this.storage = service;
        this.checkInit();
    }

    protected synchronized void setEventManager(EventManager service) {
        logger.debug("Setting event manager: {}", (Object)service);
        this.eventManager = service;
        this.checkInit();
    }

    private void checkInit() {
        logger.info("Checking init state");
        if (this.storage != null && this.eventManager != null) {
            this.disposePool();
            this.createPool(this.storage, this.eventManager);
        } else {
            this.disposePool();
        }
    }

    private void createPool(Storage storage, EventManager eventManager) {
        logger.info("Create pool: {}", (Object)this.id);
        try {
            this.pool = new EventPoolImpl(this.executor, storage, eventManager, this.filter, this.size);
            this.pool.start();
            logger.info("pool {} created", (Object)this.id);
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("service.pid", this.id);
            this.poolHandle = this.context.registerService(EventQuery.class.getName(), (Object)this.pool, properties);
        }
        catch (Exception e) {
            logger.warn("Failed to create event pool: " + this.id, (Throwable)e);
        }
    }

    public void dispose() {
        this.disposePool();
        this.executor.shutdown();
    }

    private synchronized void disposePool() {
        logger.info("Dispose pool: {}", (Object)this.id);
        if (this.poolHandle != null) {
            logger.debug("Unregister pool");
            this.poolHandle.unregister();
            this.poolHandle = null;
        }
        if (this.pool != null) {
            this.pool.stop();
            this.pool = null;
        }
    }

    public void update(String filter, int size) {
        this.filter = filter;
        this.size = size;
        this.checkInit();
    }
}

