/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.event.proxy;

import java.util.List;
import java.util.concurrent.locks.Lock;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.event.EventListener;
import org.eclipse.scada.ae.server.common.event.EventQuery;
import org.eclipse.scada.ae.server.event.proxy.AbstractEventQueryListener;
import org.eclipse.scada.ae.server.event.proxy.ProxyEventQuery;
import org.eclipse.scada.utils.osgi.FilterUtil;
import org.eclipse.scada.utils.osgi.SingleServiceListener;
import org.eclipse.scada.utils.osgi.SingleServiceTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LocalEventQueryListener
extends AbstractEventQueryListener {
    private static final Logger logger = LoggerFactory.getLogger(LocalEventQueryListener.class);
    private final SingleServiceTracker<EventQuery> tracker;
    private EventQuery service;
    private final SingleServiceListener<EventQuery> queryListener = new SingleServiceListener<EventQuery>(){

        public void serviceChange(ServiceReference<EventQuery> reference, EventQuery service) {
            LocalEventQueryListener.this.setQueryService(service);
        }
    };
    private final EventListener eventQueryListener = new EventListener(){

        public void handleEvent(List<Event> event) {
            LocalEventQueryListener.this.addEvents(event);
        }
    };

    public LocalEventQueryListener(BundleContext context, String eventQueryId, ProxyEventQuery proxyEventQuery, Lock lock) throws InvalidSyntaxException {
        super(proxyEventQuery, lock, eventQueryId);
        logger.info("Creating new listener - query: {}", (Object)eventQueryId);
        this.tracker = new SingleServiceTracker(context, FilterUtil.createClassAndPidFilter(EventQuery.class, (String)eventQueryId), this.queryListener);
        this.tracker.open();
    }

    @Override
    public void dispose() {
        this.tracker.close();
        super.dispose();
    }

    protected void setQueryService(EventQuery service) {
        this.lock.lock();
        try {
            if (service == this.service) {
                return;
            }
            if (this.service != null) {
                this.service.removeListener(this.eventQueryListener);
            }
            this.service = service;
            if (this.service != null) {
                service.addListener(this.eventQueryListener);
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

