/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.event.proxy;

import java.util.List;
import java.util.concurrent.locks.Lock;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.client.EventListener;
import org.eclipse.scada.ae.server.event.proxy.AbstractEventQueryListener;
import org.eclipse.scada.ae.server.event.proxy.ProxyEventQuery;
import org.eclipse.scada.core.connection.provider.ConnectionIdTracker;
import org.eclipse.scada.core.connection.provider.ConnectionService;
import org.eclipse.scada.core.connection.provider.ConnectionTracker;
import org.eclipse.scada.core.data.SubscriptionState;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RemoteEventQueryListener
extends AbstractEventQueryListener
implements ConnectionTracker.Listener,
EventListener {
    private static final Logger logger = LoggerFactory.getLogger(RemoteEventQueryListener.class);
    private final ConnectionIdTracker tracker;
    private org.eclipse.scada.ae.connection.provider.ConnectionService connection;
    private final String eventQueryId;

    public RemoteEventQueryListener(BundleContext context, String connectionId, String eventQueryId, ProxyEventQuery proxyEventQuery, Lock lock) {
        super(proxyEventQuery, lock, String.valueOf(connectionId) + "#" + eventQueryId);
        logger.info("Creating new listener - connection: {}, query: {}", (Object)connectionId, (Object)eventQueryId);
        this.eventQueryId = eventQueryId;
        this.tracker = new ConnectionIdTracker(context, connectionId, (ConnectionTracker.Listener)this, org.eclipse.scada.ae.connection.provider.ConnectionService.class);
        this.tracker.open();
    }

    @Override
    public void dispose() {
        this.tracker.close();
        super.dispose();
    }

    public void setConnection(ConnectionService connectionService) {
        logger.debug("Setting connection: {}", (Object)connectionService);
        this.lock.lock();
        try {
            if (this.connection != null) {
                this.connection.getConnection().setEventListener(this.eventQueryId, null);
            }
            this.connection = (org.eclipse.scada.ae.connection.provider.ConnectionService)connectionService;
            if (this.connection != null) {
                this.connection.getConnection().setEventListener(this.eventQueryId, (EventListener)this);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void statusChanged(SubscriptionState state) {
        logger.info("State of {} changed: {}", (Object)this.info, (Object)state);
    }

    public void dataChanged(List<Event> addedEvents) {
        this.addEvents(addedEvents);
    }
}

