/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.utils;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.sec.UserInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBaseConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(AbstractBaseConfiguration.class);
    private final List<Event> events = new LinkedList<Event>();
    protected final boolean initialUpdate;

    protected abstract void injectEventAttributes(Event.EventBuilder var1);

    protected abstract void sendEvent(Event var1);

    public AbstractBaseConfiguration(AbstractBaseConfiguration currentConfiguration) {
        this.initialUpdate = currentConfiguration == null;
    }

    public void sendEvents() {
        if (!this.initialUpdate) {
            for (Event event : this.events) {
                logger.debug("Sending event: {}", (Object)event);
                this.sendEvent(event);
            }
        }
        this.events.clear();
    }

    protected void addEvent(Event.EventBuilder builder) {
        this.events.add(builder.build());
    }

    protected Event.EventBuilder create(Object value, UserInformation userInformation) {
        Event.EventBuilder builder = Event.create();
        this.injectEventAttributes(builder);
        builder.attribute(Event.Fields.EVENT_TYPE, (Object)"CFG");
        if (userInformation != null) {
            builder.attribute(Event.Fields.ACTOR_TYPE, (Object)"USER");
            builder.attribute(Event.Fields.ACTOR_NAME, (Object)userInformation.getName());
        }
        builder.attribute(Event.Fields.VALUE, value);
        return builder;
    }

    protected <T> T update(UserInformation userInformation, T oldValue, T newValue) {
        if (oldValue == newValue) {
            return newValue;
        }
        if (oldValue == null) {
            this.addEvent(this.create(newValue, userInformation));
            return newValue;
        }
        if (oldValue.equals(newValue)) {
            return newValue;
        }
        this.addEvent(this.create(newValue, userInformation));
        return newValue;
    }
}

