/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.datasource.constant;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.core.VariantEditor;
import org.eclipse.scada.core.data.SubscriptionState;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.datasource.base.AbstractInputDataSource;

public class ConstantDataSource
extends AbstractInputDataSource {
    private final Executor executor;

    public ConstantDataSource(Executor executor) {
        this.executor = executor;
    }

    protected Executor getExecutor() {
        return this.executor;
    }

    public synchronized void update(Map<String, String> parameters) throws Exception {
        DataItemValue.Builder builder = new DataItemValue.Builder();
        try {
            ConfigurationDataHelper cfg = new ConfigurationDataHelper(parameters);
            builder.setValue(VariantEditor.toVariant((String)cfg.getStringChecked("value", "'value' must be provided")));
            builder.setTimestamp(this.makeTimestamp(cfg));
            for (Map.Entry entry : cfg.getPrefixed("attributes.").entrySet()) {
                builder.setAttribute((String)entry.getKey(), VariantEditor.toVariant((String)((String)entry.getValue())));
            }
            builder.setSubscriptionState(SubscriptionState.CONNECTED);
        }
        finally {
            this.updateData(builder.build());
        }
    }

    private Calendar makeTimestamp(ConfigurationDataHelper cfg) throws ParseException {
        Calendar c = Calendar.getInstance();
        String timeString = cfg.getString("timeString");
        if (timeString != null && !timeString.isEmpty()) {
            c.setTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").parse(timeString));
        }
        long timeDiff = cfg.getLong("timeDiff.value", 0L);
        TimeUnit timeDiffUnit = TimeUnit.valueOf(cfg.getString("timeDiff.unit", TimeUnit.MILLISECONDS.toString()));
        c.add(14, (int)TimeUnit.MILLISECONDS.convert(timeDiff, timeDiffUnit));
        return c;
    }
}

