/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.datasource;

import org.eclipse.scada.core.VariantType;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.datasource.DataSource;
import org.eclipse.scada.da.datasource.DataSourceHandler;
import org.eclipse.scada.da.datasource.DataSourceHandlerListener;
import org.eclipse.scada.da.datasource.DataSourceListener;
import org.eclipse.scada.da.datasource.SingleDataSourceTracker;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.osgi.framework.InvalidSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceHandlerImpl
implements DataSourceListener,
DataSourceHandler {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceHandlerImpl.class);
    private final DataSourceHandlerListener listener;
    private final SingleDataSourceTracker tracker;
    private DataSource service;
    private DataItemValue value;
    private final VariantType type;

    public DataSourceHandlerImpl(ObjectPoolTracker<DataSource> poolTracker, String datasourceId, DataSourceHandlerListener listener, VariantType type) throws InvalidSyntaxException {
        this.listener = listener;
        this.type = type;
        this.tracker = new SingleDataSourceTracker(poolTracker, datasourceId, new SingleDataSourceTracker.ServiceListener(){

            @Override
            public void dataSourceChanged(DataSource dataSource) {
                DataSourceHandlerImpl.this.setDataSource(dataSource);
            }
        });
        this.tracker.open();
    }

    protected void setDataSource(DataSource service) {
        this.disconnectService();
        if (service != null) {
            this.service = service;
            this.service.addListener(this);
        }
    }

    private void disconnectService() {
        if (this.service != null) {
            this.service.removeListener(this);
            this.service = null;
            this.value = null;
            this.fireValueChange();
        }
    }

    private void fireValueChange() {
        try {
            this.listener.handleChange();
        }
        catch (Exception e) {
            logger.warn("Failed to handle state change", (Throwable)e);
        }
    }

    @Override
    public void dispose() {
        if (this.tracker != null) {
            this.tracker.close();
        }
        this.disconnectService();
    }

    @Override
    public DataItemValue getValue() {
        return this.value;
    }

    @Override
    public VariantType getType() {
        return this.type;
    }

    @Override
    public void stateChanged(DataItemValue value) {
        this.value = value;
        this.fireValueChange();
    }
}

