/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.datasource.base;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.eclipse.scada.core.InvalidOperationException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.da.core.WriteAttributeResults;
import org.eclipse.scada.da.core.WriteResult;
import org.eclipse.scada.da.datasource.base.DataInputSource;
import org.eclipse.scada.da.datasource.base.WriteHandler;
import org.eclipse.scada.utils.concurrent.FutureTask;
import org.eclipse.scada.utils.concurrent.InstantErrorFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;

public class DataInputOutputSource
extends DataInputSource {
    private WriteHandler writeHandler;

    public DataInputOutputSource(Executor executor) {
        super(executor);
    }

    public DataInputOutputSource(Executor executor, WriteHandler writeHandler) {
        super(executor);
        this.writeHandler = writeHandler;
    }

    @Override
    public NotifyFuture<WriteResult> startWriteValue(final Variant value, final OperationParameters operationParameters) {
        final WriteHandler writeHandler = this.writeHandler;
        if (writeHandler == null) {
            return new InstantErrorFuture(new InvalidOperationException().fillInStackTrace());
        }
        FutureTask task = new FutureTask((Callable)new Callable<WriteResult>(){

            @Override
            public WriteResult call() throws Exception {
                writeHandler.handleWrite(operationParameters.getUserInformation(), value);
                return new WriteResult();
            }
        });
        this.getExecutor().execute((Runnable)task);
        return task;
    }

    @Override
    public NotifyFuture<WriteAttributeResults> startWriteAttributes(Map<String, Variant> attributes, OperationParameters operationParameters) {
        return new InstantErrorFuture(new InvalidOperationException().fillInStackTrace());
    }

    public void setWriteHandler(WriteHandler writeHandler) {
        this.writeHandler = writeHandler;
    }
}

