/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.browser.common.query;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.core.browser.Entry;
import org.eclipse.scada.da.core.server.browser.NoSuchFolderException;
import org.eclipse.scada.da.server.browser.common.Folder;
import org.eclipse.scada.da.server.browser.common.FolderCommon;
import org.eclipse.scada.da.server.browser.common.FolderListener;
import org.eclipse.scada.da.server.browser.common.query.ItemDescriptor;
import org.eclipse.scada.da.server.browser.common.query.NameProvider;
import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.utils.collection.MapBuilder;

public class GroupSubFolder
implements Folder {
    private GroupSubFolder parent = null;
    private NameProvider nameProvider = null;
    private final FolderCommon folder = new FolderCommon();
    private final Map<String, GroupSubFolder> subFolders = new HashMap<String, GroupSubFolder>();

    public GroupSubFolder(NameProvider nameProvider) {
        this(null, nameProvider);
    }

    private GroupSubFolder(GroupSubFolder parent, NameProvider nameProvider) {
        this.parent = parent;
        this.nameProvider = nameProvider;
    }

    public GroupSubFolder add(Stack<String> path, ItemDescriptor descriptor) {
        if (path.isEmpty()) {
            return this.insertItem(descriptor) ? this : null;
        }
        String next = path.pop();
        GroupSubFolder subFolder = this.getSubFolder(next);
        return subFolder.add(path, descriptor);
    }

    private boolean insertItem(ItemDescriptor descriptor) {
        String name = this.nameProvider.getName(descriptor);
        if (name == null) {
            return false;
        }
        this.folder.add(name, descriptor.getItem(), descriptor.getAttributes());
        return true;
    }

    private GroupSubFolder getSubFolder(String name) {
        if (!this.subFolders.containsKey(name)) {
            GroupSubFolder folder = new GroupSubFolder(this, this.nameProvider);
            this.subFolders.put(name, folder);
            MapBuilder builder = new MapBuilder();
            this.folder.add(name, folder, (Map<String, Variant>)builder.getMap());
        }
        return this.subFolders.get(name);
    }

    public void remove(ItemDescriptor descriptor) {
        DataItem item = descriptor.getItem();
        if (!this.folder.remove(item)) {
            return;
        }
        if (this.folder.size() <= 0 && this.parent != null) {
            this.parent.removeSubFolder(this);
        }
    }

    private void removeSubFolder(GroupSubFolder subFolder) {
        String folderName = this.folder.findEntry(subFolder);
        if (folderName == null) {
            return;
        }
        subFolder.clearSubscribers();
        this.folder.remove(folderName);
        this.subFolders.remove(folderName);
        if (this.folder.size() <= 0 && this.parent != null) {
            this.parent.removeSubFolder(this);
        }
    }

    @Override
    public synchronized Entry[] list(Stack<String> path) throws NoSuchFolderException {
        return this.folder.list(path);
    }

    @Override
    public synchronized void subscribe(Stack<String> path, FolderListener listener, Object tag) throws NoSuchFolderException {
        this.folder.subscribe(path, listener, tag);
    }

    @Override
    public synchronized void unsubscribe(Stack<String> path, Object tag) throws NoSuchFolderException {
        this.folder.unsubscribe(path, tag);
    }

    public void clearSubscribers() {
        this.folder.clearListeners();
    }

    @Override
    public void added() {
        this.folder.added();
    }

    @Override
    public void removed() {
        this.folder.removed();
    }
}

