/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.jdbc;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.da.server.common.AttributeMode;
import org.eclipse.scada.da.server.common.chain.WriteHandler;
import org.eclipse.scada.da.server.common.chain.WriteHandlerItem;
import org.eclipse.scada.da.server.common.item.factory.DefaultChainItemFactory;
import org.eclipse.scada.da.server.common.item.factory.FolderItemFactory;
import org.eclipse.scada.da.server.jdbc.Connection;
import org.eclipse.scada.utils.lang.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Update {
    private static final Logger logger = LoggerFactory.getLogger(Update.class);
    private final String id;
    private final String sql;
    private FolderItemFactory itemFactory;
    private final Connection connection;
    private WriteHandlerItem item;
    private final Collection<Mapping> mappings = new LinkedList<Mapping>();

    public Update(String id, String sql, Connection connection) {
        this.id = id;
        this.sql = sql;
        this.connection = connection;
    }

    public void register(DefaultChainItemFactory parentItemFactory) {
        this.itemFactory = parentItemFactory.createSubFolderFactory(this.id);
        this.item = this.itemFactory.createInputOutput("START", null, new WriteHandler(){

            public void handleWrite(Variant value, OperationParameters operationParameters) throws Exception {
                Update.this.performUpdate(value, operationParameters);
            }
        });
    }

    protected void performUpdate(Variant value, OperationParameters operationParameters) {
        try {
            int result = this.doUpdate(value);
            this.item.updateData(Variant.valueOf((int)result), new HashMap(), AttributeMode.SET);
        }
        catch (Exception e) {
            logger.warn("Failed to perform update", (Throwable)e);
            HashMap<String, Variant> attributes = new HashMap<String, Variant>();
            attributes.put("sql.error", Variant.TRUE);
            attributes.put("sql.error.message", Variant.valueOf((Object)e.getMessage()));
            this.item.updateData(Variant.NULL, attributes, AttributeMode.SET);
        }
    }

    /*
     * Exception decompiling
     */
    private int doUpdate(Variant value) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void applyParameters(PreparedStatement stmt, Object ... parameters) throws SQLException {
        if (parameters != null) {
            int i = 0;
            while (i < parameters.length) {
                logger.trace("Set parameter #{} - {}", (Object)(i + 1), parameters[i]);
                stmt.setObject(i + 1, parameters[i]);
                ++i;
            }
        }
    }

    public void unregister() {
        this.itemFactory.dispose();
        this.itemFactory = null;
    }

    public void addMapping(Mapping mapping) {
        this.mappings.add(mapping);
    }

    @Immutable
    public static class Mapping {
        private final String attributes;
        private final String namedParameter;

        public Mapping(String namedParameter) {
            this.attributes = null;
            this.namedParameter = namedParameter;
        }

        public Mapping(String attribute, String namedParameter) {
            this.attributes = attribute;
            this.namedParameter = namedParameter;
        }

        public String getAttributes() {
            return this.attributes;
        }

        public String getNamedParameter() {
            return this.namedParameter;
        }
    }
}

