/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.server.ngp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.mina.core.session.IoSession;
import org.eclipse.scada.ca.Configuration;
import org.eclipse.scada.ca.Factory;
import org.eclipse.scada.ca.data.ConfigurationInformation;
import org.eclipse.scada.ca.data.FactoryInformation;
import org.eclipse.scada.ca.data.message.ApplyDiffRequest;
import org.eclipse.scada.ca.data.message.ApplyDiffResponse;
import org.eclipse.scada.ca.data.message.ErrorResponse;
import org.eclipse.scada.ca.data.message.GetConfigurationRequest;
import org.eclipse.scada.ca.data.message.GetConfigurationResponse;
import org.eclipse.scada.ca.data.message.GetFactoriesRequest;
import org.eclipse.scada.ca.data.message.GetFactoriesResponse;
import org.eclipse.scada.ca.data.message.GetFactoryWithDataRequest;
import org.eclipse.scada.ca.data.message.GetFactoryWithDataResponse;
import org.eclipse.scada.ca.server.FactoryWithData;
import org.eclipse.scada.ca.server.Service;
import org.eclipse.scada.ca.server.Session;
import org.eclipse.scada.core.InvalidSessionException;
import org.eclipse.scada.core.data.ErrorInformation;
import org.eclipse.scada.core.data.Request;
import org.eclipse.scada.core.data.Response;
import org.eclipse.scada.core.data.ResponseMessage;
import org.eclipse.scada.core.server.ngp.ServiceServerConnection;
import org.eclipse.scada.utils.ExceptionHelper;
import org.eclipse.scada.utils.concurrent.FutureListener;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerConnectionImpl
extends ServiceServerConnection<Session, Service> {
    private static final Logger logger = LoggerFactory.getLogger(ServerConnectionImpl.class);

    public ServerConnectionImpl(IoSession session, Service service) {
        super(session, (org.eclipse.scada.core.server.Service)service);
    }

    public void messageReceived(Object message) throws Exception {
        logger.trace("Received message: {}", message);
        if (message instanceof GetFactoriesRequest) {
            this.handleGetFactories((GetFactoriesRequest)message);
        } else if (message instanceof GetFactoryWithDataRequest) {
            this.handleGetFactoryWithData((GetFactoryWithDataRequest)message);
        } else if (message instanceof GetConfigurationRequest) {
            this.handleGetConfigurationRequest((GetConfigurationRequest)message);
        } else if (message instanceof ApplyDiffRequest) {
            this.handleApplyDiff((ApplyDiffRequest)message);
        } else {
            super.messageReceived(message);
        }
    }

    protected void handleApplyDiff(final ApplyDiffRequest message) throws InvalidSessionException {
        new ErrorAwareHandler<Void>(this, message.getRequest(), ((Service)this.service).applyDiff((Session)this.session, (Collection)message.getDiffs(), message.getOperationParameters(), this.createCallbackHandler(message.getCallbackHandlerId()))){

            @Override
            protected ResponseMessage handle(Response response, Void result) {
                return new ApplyDiffResponse(new Response(message.getRequest()));
            }
        };
    }

    protected void handleGetConfigurationRequest(final GetConfigurationRequest message) throws InvalidSessionException {
        new ErrorAwareHandler<Configuration>(this, message.getRequest(), ((Service)this.service).getConfiguration((Session)this.session, message.getFactoryId(), message.getConfigurationId())){

            @Override
            protected ResponseMessage handle(Response response, Configuration result) {
                return new GetConfigurationResponse(new Response(message.getRequest()), this.convertConfiguration(result));
            }
        };
    }

    protected void handleGetFactoryWithData(final GetFactoryWithDataRequest message) throws InvalidSessionException {
        new ErrorAwareHandler<FactoryWithData>(this, message.getRequest(), ((Service)this.service).getFactory((Session)this.session, message.getFactoryId())){

            @Override
            protected ResponseMessage handle(Response response, FactoryWithData result) {
                return new GetFactoryWithDataResponse(new Response(message.getRequest()), this.convertFactory(result));
            }
        };
    }

    protected void handleGetFactories(final GetFactoriesRequest message) throws InvalidSessionException {
        new ErrorAwareHandler<Factory[]>(this, message.getRequest(), ((Service)this.service).getKnownFactories((Session)this.session)){

            @Override
            protected ResponseMessage handle(Response response, Factory[] result) {
                return new GetFactoriesResponse(new Response(message.getRequest()), this.convertFactories(result));
            }
        };
    }

    protected FactoryInformation convertFactory(FactoryWithData result) {
        Factory factory = result.getFactory();
        Configuration[] configurations = result.getConfigurations();
        return new FactoryInformation(factory.getId(), factory.getDescription(), factory.getState(), this.convertConfigurations(configurations));
    }

    private List<ConfigurationInformation> convertConfigurations(Configuration[] configurations) {
        if (configurations == null) {
            return null;
        }
        ArrayList<ConfigurationInformation> result = new ArrayList<ConfigurationInformation>(configurations.length);
        Configuration[] configurationArray = configurations;
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            Configuration configuration = configurationArray[n2];
            result.add(this.convertConfiguration(configuration));
            ++n2;
        }
        return result;
    }

    private ConfigurationInformation convertConfiguration(Configuration configuration) {
        return new ConfigurationInformation(configuration.getFactoryId(), configuration.getId(), configuration.getState(), configuration.getData(), ExceptionHelper.formatted((Throwable)configuration.getErrorInformation()));
    }

    protected List<FactoryInformation> convertFactories(Factory[] factories) {
        if (factories == null) {
            return null;
        }
        ArrayList<FactoryInformation> result = new ArrayList<FactoryInformation>(factories.length);
        Factory[] factoryArray = factories;
        int n = factories.length;
        int n2 = 0;
        while (n2 < n) {
            Factory factory = factoryArray[n2];
            result.add(new FactoryInformation(factory.getId(), factory.getDescription(), factory.getState(), Collections.emptyList()));
            ++n2;
        }
        return result;
    }

    private abstract class ErrorAwareHandler<M>
    implements FutureListener<M> {
        private final Request request;

        public ErrorAwareHandler(Request request, NotifyFuture<M> future) {
            this.request = request;
            future.addListener((FutureListener)this);
        }

        public void complete(Future<M> future) {
            logger.debug("Request completed");
            try {
                M result = future.get();
                ServerConnectionImpl.this.sendMessage(this.handle(new Response(this.request), result));
            }
            catch (Exception e) {
                logger.info("Request failure", (Throwable)e);
                ServerConnectionImpl.this.sendMessage(new ErrorResponse(new Response(this.request), this.makeErrorInformation(e)));
            }
        }

        protected abstract ResponseMessage handle(Response var1, M var2);

        private ErrorInformation makeErrorInformation(Exception e) {
            return new ErrorInformation(null, e.getMessage(), ExceptionHelper.formatted((Throwable)e));
        }
    }
}

