/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.monitor.datasource;

import com.google.common.collect.Interner;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.data.MonitorStatusInformation;
import org.eclipse.scada.ae.event.EventProcessor;
import org.eclipse.scada.ae.monitor.common.AbstractConfiguration;
import org.eclipse.scada.ae.monitor.common.AbstractPersistentStateMonitor;
import org.eclipse.scada.ae.monitor.common.AbstractStateMonitor;
import org.eclipse.scada.ae.monitor.common.DataItemMonitor;
import org.eclipse.scada.ae.monitor.common.PersistentInformation;
import org.eclipse.scada.ae.monitor.datasource.Activator;
import org.eclipse.scada.ae.monitor.datasource.MonitorStateInjector;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.core.WriteAttributeResult;
import org.eclipse.scada.da.core.WriteAttributeResults;
import org.eclipse.scada.da.master.MasterItem;
import org.eclipse.scada.da.master.MasterItemHandler;
import org.eclipse.scada.da.master.WriteRequest;
import org.eclipse.scada.da.master.WriteRequestResult;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.eclipse.scada.utils.osgi.pool.SingleObjectPoolServiceTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMasterItemMonitor
extends AbstractPersistentStateMonitor
implements DataItemMonitor {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMasterItemMonitor.class);
    private SingleObjectPoolServiceTracker<MasterItem> tracker;
    protected MasterItem masterItem;
    private MasterItemHandler handler;
    private String prefix;
    private final String defaultMonitorType;
    private final ObjectPoolTracker<MasterItem> poolTracker;
    private final Executor executor;
    private Configuration configuration;
    private final String factoryId;
    private final MonitorStateInjector monitorStateInjector;

    public AbstractMasterItemMonitor(BundleContext context, Executor executor, Interner<String> stringInterner, ObjectPoolTracker<MasterItem> poolTracker, EventProcessor eventProcessor, String id, String factoryId, String prefix, String defaultMonitorType) {
        super(id, factoryId, executor, context, stringInterner, eventProcessor);
        this.factoryId = factoryId;
        this.executor = executor;
        this.poolTracker = poolTracker;
        this.defaultMonitorType = defaultMonitorType;
        this.monitorStateInjector = new MonitorStateInjector(stringInterner);
        this.setPrefix(prefix);
    }

    protected void setPrefix(String prefix) {
        this.prefix = prefix;
        this.monitorStateInjector.setPrefix(prefix);
    }

    protected String getPrefix() {
        return this.prefix;
    }

    public synchronized void dispose() {
        super.dispose();
        this.disconnect();
    }

    public synchronized void akn(UserInformation userInformation, Date aknTimestamp) {
        super.akn(userInformation, aknTimestamp);
        this.reprocess();
    }

    protected synchronized void applyPersistentInformation(PersistentInformation persistentInformation) {
        super.applyPersistentInformation(persistentInformation);
        this.reprocess();
    }

    public synchronized void update(UserInformation userInformation, Map<String, String> properties) throws Exception {
        this.disconnect();
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(properties);
        Configuration c = new Configuration(this.configuration, this);
        c.setMasterId(this.intern(cfg.getStringChecked("master.id", String.format("'%s' must be set", "master.id"))));
        c.setHandlerPriority(cfg.getInteger("handlerPriority", this.getDefaultHandlerPriority()));
        c.setMonitorType(this.intern(cfg.getString("monitorType", this.defaultMonitorType)));
        c.setActiveState(userInformation, cfg.getBoolean("active", true));
        c.setSuppressEvents(userInformation, cfg.getBoolean("suppressEvents", false));
        this.configuration = c;
        c.sendEvents();
        this.setSuppressEvents(c.suppressEvents);
        this.setStringAttributes(cfg.getPrefixed("info."));
        this.connect();
    }

    protected int getDefaultHandlerPriority() {
        return 0;
    }

    private synchronized void connect() throws InvalidSyntaxException {
        if (this.configuration.masterId == null) {
            this.setUnsafe();
            throw new RuntimeException(String.format("'%s' is not set", "master.id"));
        }
        logger.debug("Setting up for master item: {}", (Object)this.configuration.masterId);
        this.tracker = new SingleObjectPoolServiceTracker(this.poolTracker, this.configuration.masterId, (SingleObjectPoolServiceTracker.ServiceListener)new SingleObjectPoolServiceTracker.ServiceListener<MasterItem>(){

            public void serviceChange(MasterItem service, Dictionary<?, ?> properties) {
                AbstractMasterItemMonitor.this.setMasterItem(service);
            }
        });
        this.tracker.open();
    }

    private void setMasterItem(final MasterItem masterItem) {
        logger.info("Setting master item: {}", (Object)masterItem);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                AbstractMasterItemMonitor.this.performSet(masterItem);
            }
        });
    }

    private synchronized void performSet(MasterItem masterItem) {
        logger.info("Perform set item: {}", (Object)masterItem);
        this.disconnectItem();
        this.connectItem(masterItem);
    }

    private synchronized void connectItem(MasterItem masterItem) {
        logger.debug("Connecting to master item: {}", (Object)masterItem);
        this.masterItem = masterItem;
        if (this.masterItem != null) {
            this.handler = new MasterItemHandler(){

                public WriteRequestResult processWrite(WriteRequest request) {
                    return AbstractMasterItemMonitor.this.handleProcessWrite(request);
                }

                public void dataUpdate(Map<String, Object> context, DataItemValue.Builder value) {
                    logger.debug("Handle data update: {}", (Object)value);
                    AbstractMasterItemMonitor.this.handleDataUpdate(context, value);
                }
            };
            this.masterItem.addHandler(this.handler, this.configuration.handlerPriority);
        }
    }

    private synchronized void disconnectItem() {
        logger.debug("Disconnect from master item: {}", (Object)this.masterItem);
        if (this.masterItem != null) {
            this.masterItem.removeHandler(this.handler);
            this.masterItem = null;
            this.handler = null;
        }
    }

    private synchronized void disconnect() {
        if (this.tracker != null) {
            this.tracker.close();
            this.tracker = null;
        }
    }

    protected void handleDataUpdate(Map<String, Object> context, DataItemValue.Builder builder) {
        if (!this.configuration.activeState) {
            this.setInactive();
        } else {
            this.performDataUpdate(context, builder);
        }
        this.injectAttributes(builder);
        logger.debug("Setting new value: {}", (Object)builder);
    }

    protected abstract void performDataUpdate(Map<String, Object> var1, DataItemValue.Builder var2);

    protected String getFactoryId() {
        return this.factoryId;
    }

    protected String getConfigurationId() {
        return this.getId();
    }

    protected synchronized void notifyStateChange(MonitorStatusInformation status) {
        super.notifyStateChange(status);
        this.monitorStateInjector.notifyStateChange(status);
    }

    protected void injectAttributes(DataItemValue.Builder builder) {
        this.monitorStateInjector.injectAttributes(builder);
    }

    private WriteRequestResult handleProcessWrite(WriteRequest request) {
        if (request.getAttributes() != null) {
            return this.handleAttributesWrite(request);
        }
        return null;
    }

    private WriteRequestResult handleAttributesWrite(WriteRequest request) {
        HashMap<String, Variant> attributes = new HashMap<String, Variant>(request.getAttributes());
        WriteAttributeResults result = new WriteAttributeResults();
        this.simpleHandleAttributes(attributes, result, request.getOperationParameters());
        for (String attr : result.keySet()) {
            attributes.remove(attr);
        }
        return new WriteRequestResult(request.getValue(), attributes, result);
    }

    private void simpleHandleAttributes(Map<String, Variant> attributes, WriteAttributeResults result, OperationParameters operationParameters) {
        HashMap<String, String> configUpdate = new HashMap<String, String>();
        this.handleConfigUpdate(configUpdate, attributes, result);
        if (!configUpdate.isEmpty()) {
            this.updateConfiguration(configUpdate, operationParameters);
        }
    }

    private void updateConfiguration(Map<String, String> configUpdate, OperationParameters operationParameters) {
        logger.info("Request to update configuration: {}", configUpdate);
        String factoryId = this.getFactoryId();
        String configurationId = this.getConfigurationId();
        logger.info("Directing update to: {}/{}", new Object[]{factoryId, configurationId});
        if (factoryId != null && configurationId != null) {
            try {
                Activator.getConfigAdmin().updateConfiguration(operationParameters.getUserInformation(), factoryId, configurationId, configUpdate, false);
            }
            catch (Exception e) {
                logger.warn("Failed to update configuration", (Throwable)e);
                throw new RuntimeException("Unable to update configuration", e);
            }
        }
    }

    protected void reprocess() {
        MasterItem item = this.masterItem;
        if (item != null) {
            item.reprocess();
        }
    }

    protected void handleConfigUpdate(Map<String, String> configUpdate, Map<String, Variant> attributes, WriteAttributeResults result) {
        Variant active = attributes.get(String.valueOf(this.prefix) + ".active");
        if (active != null) {
            configUpdate.put("active", active.asBoolean() ? "true" : "false");
            result.put((Object)this.intern(String.valueOf(this.prefix) + ".active"), (Object)WriteAttributeResult.OK);
        }
    }

    protected void injectEventAttributes(Event.EventBuilder builder) {
        super.injectEventAttributes(builder);
        if (this.configuration != null) {
            builder.attribute(Event.Fields.MONITOR_TYPE, (Object)this.configuration.monitorType);
        }
    }

    private static class Configuration
    extends AbstractConfiguration {
        private String masterId;
        private int handlerPriority;
        private String monitorType;
        private boolean activeState;
        private boolean suppressEvents;

        public Configuration(Configuration configuration, AbstractMasterItemMonitor monitor) {
            super((AbstractConfiguration)configuration, (AbstractStateMonitor)monitor);
            if (configuration != null) {
                this.masterId = configuration.masterId;
                this.handlerPriority = configuration.handlerPriority;
                this.monitorType = configuration.monitorType;
                this.activeState = configuration.activeState;
                this.suppressEvents = configuration.suppressEvents;
            }
        }

        public void setMasterId(String masterId) {
            this.masterId = masterId;
        }

        public void setHandlerPriority(int handlerPriority) {
            this.handlerPriority = handlerPriority;
        }

        public void setMonitorType(String monitorType) {
            this.monitorType = monitorType;
        }

        public void setSuppressEvents(UserInformation userInformation, boolean suppressEvents) {
            this.suppressEvents = (Boolean)this.update(userInformation, this.suppressEvents, suppressEvents);
        }

        public void setActiveState(UserInformation userInformation, boolean activeState) {
            this.activeState = (Boolean)this.update(userInformation, this.activeState, activeState);
        }
    }
}

