/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.exec;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.exec.configuration.RootType;
import org.eclipse.scada.da.server.browser.common.Folder;
import org.eclipse.scada.da.server.browser.common.FolderCommon;
import org.eclipse.scada.da.server.common.impl.HiveCommon;
import org.eclipse.scada.da.server.exec.command.CommandQueue;
import org.eclipse.scada.da.server.exec.command.ContinuousCommand;
import org.eclipse.scada.da.server.exec.command.TriggerCommand;
import org.eclipse.scada.da.server.exec.configuration.ConfigurationException;
import org.eclipse.scada.da.server.exec.configuration.XmlConfigurator;
import org.eclipse.scada.utils.collection.MapBuilder;

public class Hive
extends HiveCommon {
    private static final String TRIGGER_FOLDER_NAME = "triggers";
    private final FolderCommon rootFolder = new FolderCommon();
    private final Collection<CommandQueue> queues = new LinkedList<CommandQueue>();
    private final Collection<ContinuousCommand> continuousCommands = new LinkedList<ContinuousCommand>();
    private final Collection<TriggerCommand> triggers = new LinkedList<TriggerCommand>();
    private final FolderCommon triggerFolder;

    public Hive() throws IOException, ConfigurationException {
        this(new XmlConfigurator(URI.createFileURI((String)"configuration.xml")));
    }

    public Hive(String uri) throws ConfigurationException {
        this(new XmlConfigurator(URI.createURI((String)uri)));
    }

    public Hive(RootType root) throws ConfigurationException {
        this(new XmlConfigurator(root));
    }

    protected Hive(XmlConfigurator configurator) throws ConfigurationException {
        this.setRootFolder((Folder)this.rootFolder);
        this.triggerFolder = new FolderCommon();
        this.rootFolder.add(TRIGGER_FOLDER_NAME, (Folder)this.triggerFolder, new MapBuilder().put((Object)"description", (Object)Variant.valueOf((Object)"Contains all triggers")).getMap());
        configurator.configure(this);
    }

    public String getHiveId() {
        return "org.eclipse.scada.da.server.exec";
    }

    protected void startQueues() {
        for (CommandQueue commandQueue : this.queues) {
            commandQueue.start(this, this.rootFolder);
        }
        for (ContinuousCommand continuousCommand : this.continuousCommands) {
            continuousCommand.start(this, this.rootFolder);
        }
        for (TriggerCommand triggerCommand : this.triggers) {
            triggerCommand.register(this, this.triggerFolder);
        }
    }

    protected void performStart() throws Exception {
        super.performStart();
        this.startQueues();
    }

    protected void performStop() throws Exception {
        this.stopQueues();
        super.performStop();
    }

    protected void stopQueues() {
        for (CommandQueue commandQueue : this.queues) {
            commandQueue.stop();
        }
        for (ContinuousCommand continuousCommand : this.continuousCommands) {
            continuousCommand.stop();
        }
        for (TriggerCommand triggerCommand : this.triggers) {
            triggerCommand.unregister();
        }
    }

    public void addQueue(CommandQueue queue) {
        this.queues.add(queue);
    }

    public void addContinuousCommand(ContinuousCommand command) {
        this.continuousCommands.add(command);
    }

    public void addTrigger(TriggerCommand command) {
        this.triggers.add(command);
    }
}

