/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.exec.extractor;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scada.da.server.exec.command.ExecutionResult;
import org.eclipse.scada.da.server.exec.extractor.AbstractArrayExtractor;

public class RegExExtractor
extends AbstractArrayExtractor {
    private final Pattern pattern;
    private final boolean requireFullMatch;

    public RegExExtractor(String id, Pattern pattern, boolean requireFullMatch, List<AbstractArrayExtractor.FieldMapping> groups) {
        super(id, groups);
        this.pattern = pattern;
        this.requireFullMatch = requireFullMatch;
    }

    @Override
    protected String[] getFields(ExecutionResult result) {
        Matcher m = this.pattern.matcher(result.getOutput());
        if (this.requireFullMatch) {
            if (!m.matches()) {
                throw new RuntimeException("Failed to match input");
            }
            return this.convertToResult(m);
        }
        if (!m.find()) {
            throw new RuntimeException("Failed to match input");
        }
        return this.convertToResult(m);
    }

    private String[] convertToResult(Matcher m) {
        String[] result = new String[m.groupCount() + 1];
        int i = 0;
        while (i < result.length) {
            result[i] = m.group(i);
            ++i;
        }
        return result;
    }
}

