/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.common.event.pool.internal;

import java.util.Map;
import org.eclipse.scada.ae.server.common.event.pool.internal.EventPoolManager;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.ca.common.factory.AbstractServiceConfigurationFactory;
import org.eclipse.scada.sec.UserInformation;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventPoolConfigurationFactory
extends AbstractServiceConfigurationFactory<EventPoolManager> {
    private static final Logger logger = LoggerFactory.getLogger(EventPoolConfigurationFactory.class);

    public EventPoolConfigurationFactory(BundleContext context) {
        super(context);
    }

    protected AbstractServiceConfigurationFactory.Entry<EventPoolManager> createService(UserInformation userInformation, String configurationId, BundleContext context, Map<String, String> parameters) throws Exception {
        logger.info("Creating event pool '{}'", (Object)configurationId);
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(parameters);
        String filter = parameters.get("filter");
        Integer size = cfg.getIntegerChecked("size", "Need 'size' parameter");
        EventPoolManager manager = new EventPoolManager(context, configurationId, filter, size);
        return new AbstractServiceConfigurationFactory.Entry(configurationId, (Object)manager);
    }

    protected void disposeService(UserInformation userInformation, String id, EventPoolManager service) {
        logger.info("Disposing event pool '{}'", (Object)id);
        service.dispose();
    }

    protected AbstractServiceConfigurationFactory.Entry<EventPoolManager> updateService(UserInformation userInformation, String configurationId, AbstractServiceConfigurationFactory.Entry<EventPoolManager> entry, Map<String, String> parameters) throws Exception {
        logger.info("Updating event pool '{}'", (Object)configurationId);
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(parameters);
        String filter = parameters.get("filter");
        Integer size = cfg.getIntegerChecked("size", "Need 'size' parameter");
        ((EventPoolManager)entry.getService()).update(filter, size);
        return entry;
    }
}

