/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.common.event.pool.internal;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.event.EventListener;
import org.eclipse.scada.ae.event.EventManager;
import org.eclipse.scada.ae.filter.EventMatcher;
import org.eclipse.scada.ae.filter.internal.EventMatcherImpl;
import org.eclipse.scada.ae.server.common.event.AbstractEventQueryImpl;
import org.eclipse.scada.ae.server.storage.Query;
import org.eclipse.scada.ae.server.storage.Storage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventPoolImpl
extends AbstractEventQueryImpl
implements EventListener {
    private static final Logger logger = LoggerFactory.getLogger(EventPoolImpl.class);
    private static final int daysToRetrieve = Integer.getInteger("org.eclipse.scada.ae.common.event.pool.daysToRetrieve", 90);
    private static final String isoDatePattern = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final DateFormat isoDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private final Storage storage;
    private final EventManager eventManager;
    private final String filter;
    private final EventMatcher matcher;

    public EventPoolImpl(Executor executor, Storage storage, EventManager eventManager, String filter, int poolSize) {
        super(executor, poolSize);
        this.storage = storage;
        this.eventManager = eventManager;
        this.filter = filter;
        this.matcher = new EventMatcherImpl(filter);
    }

    public synchronized void start() throws Exception {
        this.eventManager.addEventListener((EventListener)this);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                EventPoolImpl.this.loadFromStorage();
            }
        });
    }

    public synchronized void stop() {
        this.eventManager.removeEventListener((EventListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromStorage() {
        try {
            long t = System.currentTimeMillis();
            int daysBack = 1;
            while (daysBack <= daysToRetrieve) {
                GregorianCalendar calStart = new GregorianCalendar();
                GregorianCalendar calEnd = new GregorianCalendar();
                calStart.setTimeInMillis(t);
                ((Calendar)calStart).add(6, -daysBack);
                calEnd.setTimeInMillis(t);
                ((Calendar)calEnd).add(6, -daysBack + 1);
                StringBuilder filter = new StringBuilder();
                filter.append("(&");
                filter.append(this.filter);
                filter.append("(sourceTimestamp>=" + isoDateFormat.format(calStart.getTime()) + ")");
                if (daysBack > 1) {
                    filter.append("(sourceTimestamp<" + isoDateFormat.format(calEnd.getTime()) + ")");
                }
                filter.append(")");
                logger.debug("load events from filter: " + filter);
                Query query = this.storage.query(filter.toString());
                try {
                    int count;
                    EventPoolImpl eventPoolImpl = this;
                    synchronized (eventPoolImpl) {
                        count = this.events.getCapacity();
                    }
                    List result = query.getNext((long)count);
                    logger.debug("Loaded {} entries from storage", (Object)result.size());
                    EventPoolImpl eventPoolImpl2 = this;
                    synchronized (eventPoolImpl2) {
                        this.events.addAll((Collection)result);
                        UnmodifiableIterator it = Iterators.partition((Iterator)this.events.iterator(), (int)chunkSize);
                        while (it.hasNext()) {
                            List chunk = (List)it.next();
                            this.notifyEvent(chunk);
                        }
                    }
                }
                finally {
                    query.dispose();
                }
                if (this.events.size() >= this.events.getCapacity()) {
                    return;
                }
                ++daysBack;
            }
            logger.debug("load of events complete");
        }
        catch (Exception e) {
            logger.error("loadFromStorage failed", (Throwable)e);
        }
    }

    public synchronized void handleEvent(List<Event> events) {
        this.addEvents(events, this.matcher);
    }
}

