/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.jdbc;

import java.lang.reflect.InvocationTargetException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.scada.ca.ConfigurationAdministrator;
import org.eclipse.scada.ca.FreezableConfigurationAdministrator;
import org.eclipse.scada.ca.jdbc.internal.ConfigurationAdministratorImpl;
import org.eclipse.scada.ca.jdbc.internal.JdbcStorageDAOImpl;
import org.eclipse.scada.utils.osgi.SingleServiceListener;
import org.eclipse.scada.utils.osgi.jdbc.DataSourceFactoryTracker;
import org.eclipse.scada.utils.osgi.jdbc.DataSourceHelper;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.jdbc.DataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final String CA_PREFIX = "org.eclipse.scada.ca.jdbc";
    private static final Logger logger = LoggerFactory.getLogger(Activator.class);
    private DataSourceFactoryTracker dataSourceFactoryTracker;
    private ConfigurationAdministratorImpl configAdmin;
    private ServiceRegistration<?> serviceHandle;
    private JdbcStorageDAOImpl storage;

    public void start(final BundleContext context) throws Exception {
        String driver = DataSourceHelper.getDriver((String)CA_PREFIX, (String)"org.eclipse.scada.jdbc");
        if (driver == null) {
            logger.error("JDBC driver is not set");
            throw new IllegalStateException("JDBC driver name is not set");
        }
        this.dataSourceFactoryTracker = new DataSourceFactoryTracker(context, driver, (SingleServiceListener)new SingleServiceListener<DataSourceFactory>(){

            public void serviceChange(ServiceReference<DataSourceFactory> reference, DataSourceFactory service) {
                Activator.this.unregister();
                if (service != null) {
                    try {
                        Activator.this.register(service, context);
                    }
                    catch (Exception e) {
                        logger.error("Failed to start configuration administrator", (Throwable)e);
                    }
                }
            }
        });
        this.dataSourceFactoryTracker.open(true);
    }

    public void stop(BundleContext context) throws Exception {
        this.unregister();
        this.dataSourceFactoryTracker.close();
    }

    protected void register(DataSourceFactory service, BundleContext context) throws Exception {
        logger.info("Registering services - service: {}, context: {}", (Object)service, (Object)context);
        this.storage = new JdbcStorageDAOImpl(service, Activator.getDataSourceProperties(), Activator.isConnectionPool());
        ConfigurationAdministratorImpl configAdmin = new ConfigurationAdministratorImpl(context, this.storage);
        try {
            configAdmin.start();
        }
        catch (Exception e) {
            logger.warn("Failed to start CA", (Throwable)e);
            try {
                configAdmin.dispose();
            }
            catch (Exception exception) {
                logger.warn("Failed to early dispose CA after error", (Throwable)e);
            }
            throw new InvocationTargetException(e);
        }
        this.configAdmin = configAdmin;
        Hashtable<String, String> properties = new Hashtable<String, String>(2);
        ((Dictionary)properties).put("service.vendor", "Eclipse SCADA Project");
        ((Dictionary)properties).put("service.description", "A JDBC based configuration administrator");
        this.serviceHandle = context.registerService(new String[]{ConfigurationAdministrator.class.getName(), FreezableConfigurationAdministrator.class.getName()}, (Object)this.configAdmin, properties);
    }

    public static boolean isConnectionPool() {
        return DataSourceHelper.isConnectionPool((String)CA_PREFIX, (String)"org.eclipse.scada.jdbc", (boolean)false);
    }

    private static Properties getDataSourceProperties() {
        return DataSourceHelper.getDataSourceProperties((String)CA_PREFIX, (String)"org.eclipse.scada.jdbc");
    }

    protected void unregister() {
        logger.info("Unregistering services");
        if (this.serviceHandle != null) {
            logger.info("Unregistering CA");
            this.serviceHandle.unregister();
            this.serviceHandle = null;
        }
        if (this.configAdmin != null) {
            logger.info("Disposing CA");
            this.configAdmin.dispose();
            this.configAdmin = null;
        }
        if (this.storage != null) {
            logger.info("Disposing storage");
            this.storage.dispose();
            this.storage = null;
        }
    }
}

