/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.monitor.common;

import com.google.common.collect.Interner;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import org.eclipse.scada.ae.data.MonitorStatus;
import org.eclipse.scada.ae.data.MonitorStatusInformation;
import org.eclipse.scada.ae.monitor.MonitorListener;
import org.eclipse.scada.ae.monitor.MonitorService;
import org.eclipse.scada.utils.interner.InternerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMonitorService
implements MonitorService {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMonitorService.class);
    protected Set<MonitorListener> monitorListeners = new HashSet<MonitorListener>();
    private final String id;
    private final Executor executor;
    protected MonitorStatusInformation currentState;
    private final Interner<String> stringInterner;

    public AbstractMonitorService(String id, Executor executor, Interner<String> stringInterner) {
        this.executor = executor;
        this.id = id;
        this.stringInterner = stringInterner == null ? InternerHelper.makeNoOpInterner() : stringInterner;
        this.currentState = new MonitorStatusInformation(id, MonitorStatus.INIT, System.currentTimeMillis(), null, null, null, null, null, null, null);
    }

    public String getId() {
        return this.id;
    }

    protected String intern(String string) {
        return (String)this.stringInterner.intern((Object)string);
    }

    public synchronized void addStatusListener(final MonitorListener listener) {
        if (listener == null) {
            return;
        }
        if (this.monitorListeners.add(listener)) {
            final MonitorStatusInformation state = this.currentState;
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    listener.statusChanged(state);
                }
            });
        }
    }

    protected synchronized void notifyStateChange(final MonitorStatusInformation state) {
        final MonitorListener[] listeners = this.monitorListeners.toArray(new MonitorListener[this.monitorListeners.size()]);
        this.currentState = state;
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                MonitorListener[] monitorListenerArray = listeners;
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    MonitorListener listener = monitorListenerArray[n2];
                    try {
                        listener.statusChanged(state);
                    }
                    catch (Throwable e) {
                        logger.warn("Failed to notify", e);
                    }
                    ++n2;
                }
            }
        });
    }

    public synchronized void removeStatusListener(MonitorListener listener) {
        this.monitorListeners.remove(listener);
    }
}

