/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.monitor.common;

import com.google.common.collect.Interner;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.data.MonitorStatus;
import org.eclipse.scada.ae.data.MonitorStatusInformation;
import org.eclipse.scada.ae.data.Severity;
import org.eclipse.scada.ae.event.EventProcessor;
import org.eclipse.scada.ae.monitor.common.AbstractMonitorService;
import org.eclipse.scada.ae.monitor.common.MonitorDecorator;
import org.eclipse.scada.ae.monitor.common.PersistentInformation;
import org.eclipse.scada.ae.monitor.common.State;
import org.eclipse.scada.ae.monitor.common.StateInformation;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.sec.UserInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStateMonitor
extends AbstractMonitorService {
    private static final Logger logger = LoggerFactory.getLogger(AbstractStateMonitor.class);
    private StateInformation currentState = new StateInformation(null, null, null, null, null, null, null, null, null, null);
    private final PersistentInformation persistentInformation = new PersistentInformation();
    private Map<String, Variant> attributes;
    private final EventProcessor eventProcessor;
    private boolean suppressEvents;

    public AbstractStateMonitor(String id, Executor executor, Interner<String> stringInterner, EventProcessor eventProcessor) {
        super(id, executor, stringInterner);
        this.eventProcessor = eventProcessor;
    }

    public synchronized void akn(UserInformation userInformation, Date aknTimestamp) {
        long now = System.currentTimeMillis();
        long akn = aknTimestamp == null ? now : aknTimestamp.getTime();
        String user = this.extractUser(userInformation);
        StateInformation.Builder builder = new StateInformation.Builder(this.currentState);
        builder.setLastAckTimestamp(akn);
        builder.setLastAckUser(user);
        Event.EventBuilder event = this.createEvent(userInformation);
        event.attribute(Event.Fields.EVENT_TYPE, (Object)"AKN");
        this.sendEvent(event);
        this.persistentInformation.setLastAckTimestamp(akn);
        this.persistentInformation.setLastAckUser(user);
        this.storePersistentInformation(this.persistentInformation);
        this.setState(builder, now, null);
    }

    protected void sendEvent(Event.EventBuilder builder) {
        this.sendEvent(builder.build());
    }

    protected void sendEvent(Event event) {
        this.sendEvent(event, false);
    }

    protected void sendEvent(Event event, boolean force) {
        logger.debug("Sending event: {} - suppressEvents: {}, force: {}", new Object[]{event, this.suppressEvents, force});
        if (!this.suppressEvents || force) {
            this.eventProcessor.publishEvent(event);
        }
    }

    private String extractUser(UserInformation userInformation) {
        if (userInformation == null) {
            return null;
        }
        return userInformation.getName();
    }

    protected void setState(StateInformation.Builder builder, long now, MonitorDecorator decorator) {
        if (this.isEqual(builder.build())) {
            logger.trace("No change detected");
            return;
        }
        builder.setLastChangeTimestamp(now);
        this.currentState = builder.build();
        MonitorStatusInformation newState = this.renderState(decorator);
        this.notifyStateChange(newState);
        this.sendEvent(this.createStateEvent(newState, decorator));
    }

    protected Event.EventBuilder createEvent(UserInformation userInformation) {
        Event.EventBuilder builder = Event.create();
        this.injectEventAttributes(builder);
        if (userInformation != null) {
            builder.attribute(Event.Fields.ACTOR_TYPE, (Object)"USER");
            builder.attribute(Event.Fields.ACTOR_NAME, (Object)userInformation.getName());
        }
        return builder;
    }

    private Event createStateEvent(MonitorStatusInformation state, MonitorDecorator decorator) {
        Event.EventBuilder builder = this.createEvent(null);
        builder.attribute(Event.Fields.VALUE, state.getValue());
        builder.attribute(Event.Fields.EVENT_TYPE, (Object)state.getStatus());
        builder.attribute(Event.Fields.SEVERITY, (Object)state.getSeverity());
        if (decorator != null) {
            decorator.decorateEvent(builder);
        }
        return builder.build();
    }

    private boolean isEqual(StateInformation stateInformation) {
        if (this.currentState == null) {
            return false;
        }
        return this.currentState.equals(stateInformation);
    }

    private MonitorStatusInformation renderState(MonitorDecorator decorator) {
        Map<String, Variant> attributes;
        MonitorStatus status;
        logger.debug("Current state - {}", (Object)this.currentState);
        if (this.currentState == null || this.currentState.getState() == null) {
            status = MonitorStatus.INIT;
        } else {
            switch (this.currentState.getState()) {
                case INACTIVE: {
                    status = MonitorStatus.INACTIVE;
                    break;
                }
                case OK: {
                    status = this.ack(MonitorStatus.OK, MonitorStatus.NOT_AKN);
                    break;
                }
                case UNSAFE: {
                    status = MonitorStatus.UNSAFE;
                    break;
                }
                case NOT_OK: {
                    status = this.ack(MonitorStatus.NOT_OK, MonitorStatus.NOT_OK_NOT_AKN);
                    break;
                }
                default: {
                    status = MonitorStatus.UNSAFE;
                }
            }
        }
        if (decorator != null) {
            attributes = new HashMap<String, Variant>(this.attributes);
            decorator.decorateMonitorAttributes(attributes);
        } else {
            attributes = this.attributes;
        }
        return new MonitorStatusInformation(this.getId(), status, this.currentState.getLastChangeTimestamp().longValue(), this.currentState.getSeverity(), this.currentState.getValue(), this.currentState.getLastAckTimestamp(), this.currentState.getLastAckUser(), this.currentState.getLastFailTimestamp(), this.currentState.getLastFailValue(), attributes);
    }

    public StateInformation getCurrentState() {
        return this.currentState;
    }

    private MonitorStatus ack(MonitorStatus withAkn, MonitorStatus withoutAkn) {
        return AbstractStateMonitor.needAck(this.currentState) ? withoutAkn : withAkn;
    }

    private static boolean needAck(StateInformation state) {
        if (state.getLastAckRequiredTimestamp() == null) {
            return false;
        }
        if (state.getLastAckTimestamp() == null) {
            return true;
        }
        return state.getLastAckRequiredTimestamp() > state.getLastAckTimestamp();
    }

    public synchronized void setSuppressEvents(boolean suppressEvents) {
        this.suppressEvents = suppressEvents;
    }

    public boolean isSuppressEvents() {
        return this.suppressEvents;
    }

    protected synchronized void setAttributes(Map<String, Variant> attributes) {
        this.attributes = attributes;
    }

    protected synchronized void setStringAttributes(Map<String, String> attributes) {
        HashMap<String, Variant> convertedAttributes = new HashMap<String, Variant>(attributes.size());
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            convertedAttributes.put(entry.getKey(), Variant.valueOf((Object)entry.getValue()));
        }
        this.setAttributes(convertedAttributes);
    }

    protected void buildMonitorAttributes(Map<String, Variant> attributes) {
        attributes.putAll(this.attributes);
    }

    protected void injectEventAttributes(Event.EventBuilder builder) {
        builder.attribute(Event.Fields.SOURCE, (Object)this.getId());
        builder.attributes(this.attributes);
    }

    protected void setUnsafe() {
        StateInformation.Builder builder = new StateInformation.Builder(this.currentState);
        builder.setState(State.UNSAFE);
        this.setState(builder, System.currentTimeMillis(), null);
    }

    protected void setOk(Variant value, Long valueTimestamp) {
        StateInformation.Builder builder = new StateInformation.Builder(this.currentState);
        builder.setState(State.OK);
        if (this.isEqual(builder.build())) {
            return;
        }
        builder.setValue(value);
        builder.setLastValueTimestamp(valueTimestamp);
        this.setState(builder, System.currentTimeMillis(), null);
    }

    protected void triggerFailure(Variant value, Long valueTimestamp, Severity severity, boolean requireAck, MonitorDecorator decorator) {
        StateInformation.Builder builder = new StateInformation.Builder(this.currentState);
        long now = System.currentTimeMillis();
        builder.setState(State.OK);
        builder.setSeverity(severity);
        if (requireAck) {
            builder.setLastAckRequiredTimestamp(now);
        } else {
            builder.setLastAckRequiredTimestamp(null);
        }
        builder.setValue(value);
        builder.setLastValueTimestamp(valueTimestamp);
        builder.setLastFailTimestamp(now);
        builder.setLastFailValue(value);
        this.setState(builder, now, decorator);
    }

    protected void setFailure(Variant value, Long valueTimestamp, Severity severity, boolean requireAck) {
        this.setFailure(value, valueTimestamp, severity, requireAck, null);
    }

    protected void setFailure(Variant value, Long valueTimestamp, Severity severity, boolean requireAck, MonitorDecorator decorator) {
        StateInformation.Builder builder = new StateInformation.Builder(this.currentState);
        builder.setState(State.NOT_OK);
        builder.setSeverity(severity);
        long now = System.currentTimeMillis();
        if (!requireAck) {
            builder.setLastAckRequiredTimestamp(null);
        } else if (this.currentState.getLastAckRequiredTimestamp() == null) {
            builder.setLastAckRequiredTimestamp(now);
        }
        if (this.isEqual(builder.build())) {
            logger.info("No change");
            return;
        }
        builder.setValue(value);
        builder.setLastValueTimestamp(valueTimestamp);
        builder.setLastFailTimestamp(now);
        builder.setLastFailValue(value);
        if (this.persistentInformation == null) {
            this.persistentInformation.setLastFailTimestamp(now);
        }
        this.storePersistentInformation(this.persistentInformation);
        if (requireAck) {
            builder.setLastAckRequiredTimestamp(now);
        } else {
            builder.setLastAckRequiredTimestamp(null);
        }
        this.setState(builder, now, decorator);
    }

    protected void setInactive() {
        StateInformation.Builder builder = new StateInformation.Builder(this.currentState);
        builder.setState(State.INACTIVE);
        this.setState(builder, System.currentTimeMillis(), null);
    }

    protected synchronized void applyPersistentInformation(PersistentInformation persistentInformation) {
        if (persistentInformation == null) {
            return;
        }
        logger.debug("Applying persistent information : {}", (Object)persistentInformation);
        StateInformation.Builder builder = new StateInformation.Builder(this.currentState);
        if (this.currentState.getLastAckTimestamp() == null) {
            builder.setLastAckTimestamp(persistentInformation.getLastAckTimestamp());
            builder.setLastAckUser(persistentInformation.getLastAckUser());
            this.persistentInformation.setLastAckTimestamp(persistentInformation.getLastAckTimestamp());
            this.persistentInformation.setLastAckUser(persistentInformation.getLastAckUser());
        }
        if (this.currentState.getLastFailTimestamp() == null) {
            builder.setLastFailTimestamp(persistentInformation.getLastFailTimestamp());
            builder.setLastFailValue(persistentInformation.getLastFailValue());
            this.persistentInformation.setLastFailTimestamp(persistentInformation.getLastFailTimestamp());
        }
        this.setState(builder, System.currentTimeMillis(), null);
    }

    protected abstract void storePersistentInformation(PersistentInformation var1);
}

