/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common.chain;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.eclipse.scada.core.InvalidOperationException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.da.core.DataItemInformation;
import org.eclipse.scada.da.core.WriteResult;
import org.eclipse.scada.da.server.common.chain.DataItemInputOutputChained;
import org.eclipse.scada.da.server.common.chain.WriteHandler;
import org.eclipse.scada.utils.concurrent.FutureTask;
import org.eclipse.scada.utils.concurrent.InstantErrorFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;

public class WriteHandlerItem
extends DataItemInputOutputChained {
    private volatile WriteHandler writeHandler;

    public WriteHandlerItem(DataItemInformation di, WriteHandler writeHandler, Executor executor) {
        super(di, executor);
        this.writeHandler = writeHandler;
    }

    public WriteHandlerItem(String itemId, WriteHandler writeHandler, Executor executor) {
        super(itemId, executor);
        this.writeHandler = writeHandler;
    }

    public void setWriteHandler(WriteHandler writeHandler) {
        this.writeHandler = writeHandler;
    }

    @Override
    protected NotifyFuture<WriteResult> startWriteCalculatedValue(final Variant value, final OperationParameters operationParameters) {
        final WriteHandler writeHandler = this.writeHandler;
        if (writeHandler == null) {
            return new InstantErrorFuture(new InvalidOperationException().fillInStackTrace());
        }
        FutureTask task = new FutureTask((Callable)new Callable<WriteResult>(){

            @Override
            public WriteResult call() throws Exception {
                writeHandler.handleWrite(value, operationParameters);
                return new WriteResult();
            }
        });
        this.executor.execute((Runnable)task);
        return task;
    }
}

