/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.scada.core.InvalidSessionException;
import org.eclipse.scada.core.server.common.session.AbstractSessionImpl;
import org.eclipse.scada.da.core.Location;
import org.eclipse.scada.da.core.browser.Entry;
import org.eclipse.scada.da.core.server.Session;
import org.eclipse.scada.da.core.server.browser.HiveBrowser;
import org.eclipse.scada.da.core.server.browser.NoSuchFolderException;
import org.eclipse.scada.da.server.browser.common.Folder;
import org.eclipse.scada.da.server.browser.common.FolderListener;
import org.eclipse.scada.da.server.common.impl.BrowseCallable;
import org.eclipse.scada.da.server.common.impl.HiveCommon;
import org.eclipse.scada.da.server.common.impl.SessionCommon;
import org.eclipse.scada.da.server.common.impl.SessionListener;
import org.eclipse.scada.utils.concurrent.FutureTask;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HiveBrowserCommon
implements HiveBrowser,
FolderListener,
SessionListener {
    private static final Logger logger = LoggerFactory.getLogger(HiveBrowserCommon.class);
    private HiveCommon hive = null;
    private final Map<Object, SessionCommon> subscriberMap = new HashMap<Object, SessionCommon>();
    private ExecutorService operationService;

    public HiveBrowserCommon(HiveCommon hive) {
        this.hive = hive;
        this.hive.addSessionListener(this);
    }

    public void start() {
        this.operationService = Executors.newFixedThreadPool(1);
    }

    public void stop() {
        this.operationService.shutdown();
    }

    public NotifyFuture<Entry[]> startBrowse(Session session, Location location) throws InvalidSessionException {
        logger.debug("List request for: {}", (Object)location);
        SessionCommon sessionCommon = this.hive.validateSession((org.eclipse.scada.core.server.Session)session);
        Folder folder = this.getRootFolder();
        FutureTask future = new FutureTask((Callable)new BrowseCallable(folder, location));
        sessionCommon.addFuture((NotifyFuture<?>)future);
        this.operationService.execute((Runnable)future);
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(Session session, Location location) throws NoSuchFolderException, InvalidSessionException {
        this.hive.validateSession((org.eclipse.scada.core.server.Session)session);
        if (this.getRootFolder() == null) {
            logger.warn("Having a brower interface without root folder");
            throw new NoSuchFolderException(location.asArray());
        }
        Stack pathStack = location.getPathStack();
        Map<Object, SessionCommon> map = this.subscriberMap;
        synchronized (map) {
            logger.debug("Adding path: {}", (Object)location);
            SessionCommon sessionCommon = (SessionCommon)session;
            Object tag = new Object();
            sessionCommon.getData().addPath(tag, new Location(location));
            this.subscriberMap.put(tag, sessionCommon);
            boolean success = false;
            try {
                this.getRootFolder().subscribe(pathStack, this, tag);
                success = true;
            }
            finally {
                if (!success) {
                    sessionCommon.getData().removePath(new Location(location));
                    this.subscriberMap.remove(tag);
                }
            }
        }
    }

    public void unsubscribe(Session session, Location location) throws NoSuchFolderException, InvalidSessionException {
        this.hive.validateSession((org.eclipse.scada.core.server.Session)session);
        if (this.getRootFolder() == null) {
            logger.warn("Having a brower interface without root folder");
            throw new NoSuchFolderException(location.asArray());
        }
        this.unsubscribePath((SessionCommon)session, location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unsubscribePath(SessionCommon session, Location location) throws NoSuchFolderException {
        Object tag = session.getData().getTag(new Location(location));
        if (tag != null) {
            session.getData().removePath(location);
            Map<Object, SessionCommon> map = this.subscriberMap;
            synchronized (map) {
                this.subscriberMap.remove(tag);
            }
            Stack pathStack = location.getPathStack();
            this.getRootFolder().unsubscribe(pathStack, tag);
        }
    }

    @Override
    public void changed(Object tag, List<Entry> added, Set<String> removed, boolean full) {
        SessionCommon session = this.subscriberMap.get(tag);
        if (session != null) {
            Location location = session.getData().getPaths().get(tag);
            try {
                session.getFolderListener().folderChanged(location, added, removed, full);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void create(AbstractSessionImpl session) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy(SessionCommon session) {
        HashMap<Object, Location> entries;
        logger.debug("Session destroy: {} entries", (Object)session.getData().getPaths().size());
        Map<Object, Location> map = session.getData().getPaths();
        synchronized (map) {
            entries = new HashMap<Object, Location>(session.getData().getPaths());
        }
        for (Map.Entry entry : entries.entrySet()) {
            try {
                logger.debug("Unsubscribe path: {}", entry.getValue());
                this.unsubscribePath(session, (Location)entry.getValue());
            }
            catch (NoSuchFolderException e) {
                logger.debug("Unable to unsubscribe form path", (Throwable)e);
            }
        }
        session.getData().clearPaths();
        logger.debug("Destruction of session ok");
    }

    public abstract Folder getRootFolder();
}

