/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.datasource.formula;

import java.io.Serializable;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.core.NotConvertableException;
import org.eclipse.scada.core.NullValueException;
import org.eclipse.scada.core.OperationException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.VariantType;
import org.eclipse.scada.core.data.SubscriptionState;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.core.WriteAttributeResults;
import org.eclipse.scada.da.core.WriteResult;
import org.eclipse.scada.da.datasource.DataSource;
import org.eclipse.scada.da.datasource.DataSourceHandler;
import org.eclipse.scada.da.datasource.SingleDataSourceTracker;
import org.eclipse.scada.da.datasource.base.AbstractMultiSourceDataSource;
import org.eclipse.scada.utils.concurrent.AbstractFuture;
import org.eclipse.scada.utils.concurrent.FutureListener;
import org.eclipse.scada.utils.concurrent.InstantErrorFuture;
import org.eclipse.scada.utils.concurrent.InstantFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormulaDataSource
extends AbstractMultiSourceDataSource {
    private static final String DEFAULT_ENGINE_NAME = System.getProperty("org.eclipse.scada.da.datasource.formula.defaultScriptEngine", "JavaScript");
    static final Logger logger = LoggerFactory.getLogger(FormulaDataSource.class);
    private final ScheduledExecutorService executor;
    private final ScriptEngineManager manager;
    private SimpleScriptContext scriptContext;
    private String inputFormula;
    private volatile String outputFormula;
    private ScriptEngine scriptEngine;
    private final ClassLoader classLoader;
    private volatile DataSource outputDataSource;
    private SingleDataSourceTracker outputItemTracker;
    private final SingleDataSourceTracker.ServiceListener outputListener;
    private String writeValueName;
    private CompiledScript inputScript;
    private CompiledScript outputScript;
    private boolean precompile;
    private VariantType outputDatasourceType;
    private final ObjectPoolTracker<DataSource> poolTracker;

    public FormulaDataSource(BundleContext context, ObjectPoolTracker<DataSource> poolTracker, ScheduledExecutorService executor) {
        super(poolTracker);
        this.poolTracker = poolTracker;
        this.outputListener = new SingleDataSourceTracker.ServiceListener(){

            public void dataSourceChanged(DataSource dataSource) {
                FormulaDataSource.this.setOutputDataSource(dataSource);
            }
        };
        this.executor = executor;
        this.classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            this.manager = new ScriptEngineManager(this.classLoader);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    protected void setOutputDataSource(DataSource dataSource) {
        this.outputDataSource = dataSource;
    }

    protected Executor getExecutor() {
        return this.executor;
    }

    public NotifyFuture<WriteAttributeResults> startWriteAttributes(Map<String, Variant> attributes, OperationParameters operationParameters) {
        DataSource outputDataSource = this.outputDataSource;
        if (outputDataSource != null) {
            return outputDataSource.startWriteAttributes(attributes, operationParameters);
        }
        return new InstantErrorFuture((Throwable)new OperationException("Output not connected"));
    }

    public NotifyFuture<WriteResult> startWriteValue(Variant value, OperationParameters operationParameters) {
        WriteFuture write = new WriteFuture(value, operationParameters);
        this.getExecutor().execute(write);
        return write;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NotifyFuture<WriteResult> processWrite(Variant writeValue, OperationParameters operationParameters) throws Exception {
        String outputFormula = this.outputFormula;
        DataSource outputDataSource = this.outputDataSource;
        if (outputFormula == null || this.outputFormula.isEmpty()) {
            throw new OperationException("Output direction not supported by this item");
        }
        if (outputDataSource == null) {
            throw new OperationException("Output item not connected");
        }
        if (writeValue == null) {
            return new InstantFuture((Object)WriteResult.OK);
        }
        FormulaDataSource formulaDataSource = this;
        synchronized (formulaDataSource) {
            Serializable writeValueObject = writeValue.as(this.outputDatasourceType);
            logger.debug("Converted write value from '{}' to '{}'", (Object)writeValue, (Object)writeValueObject);
            Map sources = this.getSourcesCopy();
            HashMap<String, Serializable> values = new HashMap<String, Serializable>(sources.size());
            int error = 0;
            for (Map.Entry entry : sources.entrySet()) {
                Variant variantValue;
                VariantType type = ((DataSourceHandler)entry.getValue()).getType();
                DataItemValue value = ((DataSourceHandler)entry.getValue()).getValue();
                if (value.isError()) {
                    ++error;
                }
                if ((variantValue = value.getValue()) != null) {
                    values.put((String)entry.getKey(), variantValue.as(type));
                    continue;
                }
                values.put((String)entry.getKey(), null);
            }
            if (error > 0) {
                throw new OperationException(String.format("Failed to write. %s input(s) are in 'error' state", error));
            }
            for (Map.Entry entry : values.entrySet()) {
                this.scriptContext.setAttribute((String)entry.getKey(), entry.getValue(), 100);
            }
            this.scriptContext.setAttribute(this.writeValueName, writeValueObject, 100);
            Object o = this.executeScript(outputFormula, this.outputScript);
            logger.debug("Result of output script: {}", o);
            Variant result = Variant.valueOf((Object)o);
            return outputDataSource.startWriteValue(result, operationParameters);
        }
    }

    public synchronized void update(Map<String, String> parameters) throws Exception {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            ConfigurationDataHelper cfg = new ConfigurationDataHelper(parameters);
            this.precompile = cfg.getBoolean("precompile", true);
            this.setScript(cfg);
            this.setDataSources(parameters);
            this.outputDatasourceType = this.getType(cfg.getString("outputDatasource.type", null));
            this.setOutputDataSource(cfg.getString("outputDatasource.id", null));
            this.writeValueName = cfg.getString("writeValueName", "writeValue");
            this.handleChange(this.getSourcesCopy());
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    private void setScript(ConfigurationDataHelper cfg) throws ScriptException {
        String engine = cfg.getString("engine", DEFAULT_ENGINE_NAME);
        if (engine.isEmpty()) {
            engine = DEFAULT_ENGINE_NAME;
        }
        this.scriptContext = new SimpleScriptContext();
        this.scriptEngine = this.manager.getEngineByName(engine);
        if (this.scriptEngine == null) {
            throw new IllegalArgumentException(String.format("'%s' is not a valid script engine", engine));
        }
        PriorityQueue<InitCode> init = new PriorityQueue<InitCode>();
        for (Map.Entry entry : cfg.getPrefixed("init.").entrySet()) {
            init.add(new InitCode(Integer.valueOf((String)entry.getKey()), (String)entry.getValue()));
        }
        while (!init.isEmpty()) {
            InitCode initCode = (InitCode)init.poll();
            logger.debug("Initializing #{}", (Object)initCode.getOrder());
            this.scriptEngine.eval(initCode.getCode(), (ScriptContext)this.scriptContext);
        }
        this.inputFormula = cfg.getString("inputFormula");
        this.outputFormula = cfg.getString("outputFormula");
        this.inputScript = null;
        this.outputScript = null;
        if (this.scriptEngine instanceof Compilable && this.precompile) {
            logger.debug("Using precompiled scripts");
            Compilable compilable = (Compilable)((Object)this.scriptEngine);
            if (this.inputFormula != null && this.inputFormula.isEmpty()) {
                this.inputScript = compilable.compile(this.inputFormula);
            }
            if (this.outputFormula != null && this.outputFormula.isEmpty()) {
                this.outputScript = compilable.compile(this.outputFormula);
            }
        }
    }

    private static void incMap(String key, Map<String, Integer> map) {
        Integer value = map.get(key);
        if (value == null) {
            value = 0;
        }
        value = value + 1;
        map.put(key, value);
    }

    protected synchronized void handleChange(Map<String, DataSourceHandler> sources) {
        if (this.inputFormula == null || this.inputFormula.isEmpty()) {
            this.updateData(null);
            return;
        }
        try {
            HashMap<String, Integer> flags = new HashMap<String, Integer>(4);
            HashMap<String, Object> values = new HashMap<String, Object>(sources.size());
            this.gatherData(sources, flags, values);
            for (Map.Entry entry : values.entrySet()) {
                this.scriptContext.setAttribute((String)entry.getKey(), entry.getValue(), 100);
            }
            this.executeScript(this.inputFormula, this.inputScript, flags);
        }
        catch (Throwable e) {
            logger.info("Failed to evaluate", e);
            logger.debug("Failed script: {}", (Object)this.inputFormula);
            this.setError(e);
        }
    }

    private void gatherData(Map<String, DataSourceHandler> sources, Map<String, Integer> flags, Map<String, Object> values) throws NullValueException, NotConvertableException {
        for (Map.Entry<String, DataSourceHandler> entry : sources.entrySet()) {
            Variant variantValue;
            VariantType type = entry.getValue().getType();
            DataItemValue value = entry.getValue().getValue();
            if (value.isAlarm()) {
                FormulaDataSource.incMap("alarm", flags);
            }
            if (value.isError()) {
                FormulaDataSource.incMap("error", flags);
            }
            if (value.isWarning()) {
                FormulaDataSource.incMap("warning", flags);
            }
            if (value.isManual()) {
                FormulaDataSource.incMap("manual", flags);
            }
            if ((variantValue = value.getValue()) != null) {
                values.put(entry.getKey(), variantValue.as(type));
                continue;
            }
            values.put(entry.getKey(), null);
        }
    }

    protected Object executeScript(String command, CompiledScript compiledScript) throws ScriptException {
        if (command == null) {
            return null;
        }
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            if (compiledScript != null) {
                Object object = compiledScript.eval(this.scriptContext);
                return object;
            }
            Object object = this.scriptEngine.eval(command, (ScriptContext)this.scriptContext);
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    protected void executeScript(String command, CompiledScript compiledScript, Map<String, Integer> flags) throws Exception {
        if (command == null) {
            return;
        }
        this.setResult(this.executeScript(command, compiledScript), flags);
    }

    private synchronized void setError(Throwable e) {
        DataItemValue.Builder builder = new DataItemValue.Builder();
        builder.setValue(Variant.NULL);
        builder.setTimestamp(Calendar.getInstance());
        builder.setAttribute("formula.error", Variant.TRUE);
        if (e != null) {
            builder.setAttribute("formula.error.class", Variant.valueOf((Object)e.getClass().getName()));
            builder.setAttribute("formula.error.message", Variant.valueOf((Object)e.getMessage()));
        }
        this.updateData(builder.build());
    }

    private synchronized void setResult(Object result, Map<String, Integer> flags) {
        logger.debug("Setting result: {}", result);
        DataItemValue.Builder builder = new DataItemValue.Builder();
        builder.setSubscriptionState(SubscriptionState.CONNECTED);
        builder.setValue(Variant.valueOf((Object)result));
        for (Map.Entry<String, Integer> entry : flags.entrySet()) {
            builder.setAttribute(String.format("formula.source.%s", entry.getKey()), Variant.valueOf((entry.getValue() > 0 ? 1 : 0) != 0));
            builder.setAttribute(String.format("formula.source.%s.count", entry.getKey()), Variant.valueOf((Object)entry.getValue()));
        }
        this.updateData(builder.build());
    }

    protected synchronized void setOutputDataSource(String dataSourceId) throws InvalidSyntaxException {
        if (this.outputItemTracker != null) {
            this.outputItemTracker.close();
            this.outputItemTracker = null;
        }
        this.outputItemTracker = new SingleDataSourceTracker(this.poolTracker, dataSourceId, this.outputListener);
        this.outputItemTracker.open();
    }

    private static final class InitCode
    implements Comparable<InitCode> {
        private final int order;
        private final String code;

        public InitCode(int order, String code) {
            this.order = order;
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }

        public int getOrder() {
            return this.order;
        }

        @Override
        public int compareTo(InitCode o) {
            return Integer.valueOf(this.order).compareTo(o.order);
        }
    }

    private final class WriteFuture
    extends AbstractFuture<WriteResult>
    implements Runnable {
        private final Variant value;
        private final OperationParameters operationParameters;

        public WriteFuture(Variant value, OperationParameters operationParameters) {
            this.value = value;
            this.operationParameters = operationParameters;
        }

        @Override
        public void run() {
            try {
                NotifyFuture<WriteResult> future = FormulaDataSource.this.processWrite(this.value, this.operationParameters);
                future.addListener((FutureListener)new FutureListener<WriteResult>(){

                    public void complete(Future<WriteResult> future) {
                        try {
                            WriteFuture.this.setResult(future.get());
                        }
                        catch (Throwable e) {
                            WriteFuture.this.setError(e);
                        }
                    }
                });
            }
            catch (Throwable e) {
                this.setError(e);
            }
        }
    }
}

