/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.exporter.http.server.internal;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.scada.hd.Query;
import org.eclipse.scada.hd.QueryListener;
import org.eclipse.scada.hd.QueryState;
import org.eclipse.scada.hd.data.QueryParameters;
import org.eclipse.scada.hd.data.ValueInformation;
import org.eclipse.scada.hd.exporter.http.DataPoint;
import org.eclipse.scada.hd.exporter.http.HttpExporter;
import org.eclipse.scada.hd.server.Service;
import org.eclipse.scada.hd.server.Session;
import org.eclipse.scada.utils.concurrent.AbstractFuture;

public class LocalHttpExporter
implements HttpExporter {
    private final Service hdService;
    private final Session session;

    public LocalHttpExporter(Service hdService) throws Exception {
        this.hdService = hdService;
        this.session = (Session)this.hdService.createSession(new Properties(), null).get();
    }

    public List<DataPoint> getData(String item, String type, Date from, Date to, Integer number) {
        QueryParameters parameters = new QueryParameters(from.getTime(), to.getTime(), number.intValue());
        QueryFuture queryFuture = new QueryFuture(type);
        Query q = null;
        try {
            q = this.hdService.createQuery(this.session, item, parameters, (QueryListener)queryFuture, false);
            List result = (List)queryFuture.get(30L, TimeUnit.SECONDS);
            q.close();
            queryFuture = null;
            q = null;
            return result;
        }
        catch (Exception exception) {
            queryFuture = null;
            if (q != null) {
                q.close();
                q = null;
            }
            return null;
        }
    }

    public List<String> getItems() {
        return new ArrayList<String>();
    }

    public List<String> getSeries(String itemId) {
        return new ArrayList<String>();
    }

    private class QueryFuture
    extends AbstractFuture<List<DataPoint>>
    implements QueryListener {
        final List<DataPoint> result = new ArrayList<DataPoint>();
        final String type;

        public QueryFuture(String type) {
            this.type = type;
        }

        public void updateData(int index, Map<String, List<Double>> values, List<ValueInformation> valueInformation) {
            int i = 0;
            for (ValueInformation vi : valueInformation) {
                DataPoint dp = new DataPoint();
                dp.setQuality(Double.valueOf(vi.getQuality()));
                dp.setManual(Double.valueOf(vi.getManualPercentage()));
                dp.setTimestamp(new Date(vi.getStartTimestamp()));
                dp.setValue(values.get(this.type).get(i));
                this.result.add(dp);
                ++i;
            }
        }

        public void updateParameters(QueryParameters parameters, Set<String> valueTypes) {
        }

        public void updateState(QueryState state) {
            if (state == QueryState.COMPLETE || state == QueryState.DISCONNECTED) {
                this.setResult(this.result);
            }
        }
    }
}

