/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.client;

import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.data.SubscriptionState;
import org.eclipse.scada.utils.lang.Immutable;

@Immutable
public class DataItemValue {
    private final Variant value;
    private final Map<String, Variant> attributes;
    private final SubscriptionState subscriptionState;
    private final Throwable subscriptionError;
    public static final DataItemValue DISCONNECTED = new DataItemValue();

    private DataItemValue() {
        this.attributes = Collections.emptyMap();
        this.value = Variant.NULL;
        this.subscriptionState = SubscriptionState.DISCONNECTED;
        this.subscriptionError = null;
    }

    public DataItemValue(Variant value, Map<String, Variant> attributes, SubscriptionState subscriptionState) {
        this.attributes = DataItemValue.makeAttributes(attributes);
        this.subscriptionState = subscriptionState;
        this.subscriptionError = null;
        this.value = Variant.valueOf((Object)value);
    }

    public DataItemValue(Variant value, Map<String, Variant> attributes, SubscriptionState subscriptionState, Throwable subscriptionError) {
        this.attributes = DataItemValue.makeAttributes(attributes);
        this.subscriptionState = subscriptionState;
        this.value = Variant.valueOf((Object)value);
        this.subscriptionError = subscriptionError;
    }

    private static Map<String, Variant> makeAttributes(Map<String, Variant> attributes) {
        if (attributes == null || attributes.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Variant> result = new HashMap<String, Variant>(attributes.size());
        for (Map.Entry<String, Variant> entry : attributes.entrySet()) {
            String key = entry.getKey();
            Variant value = entry.getValue();
            if (key == null || value == null || value.isNull()) continue;
            result.put(key, value);
        }
        return result;
    }

    public DataItemValue(DataItemValue div) {
        this.attributes = div.attributes;
        this.value = div.value;
        this.subscriptionError = div.subscriptionError;
        this.subscriptionState = div.subscriptionState;
    }

    public Variant getValue() {
        return this.value;
    }

    public Map<String, Variant> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public SubscriptionState getSubscriptionState() {
        return this.subscriptionState;
    }

    public String getSubscriptionErrorString() {
        Throwable subscriptionError = this.subscriptionError;
        if (subscriptionError != null) {
            return subscriptionError.getMessage();
        }
        return null;
    }

    public Throwable getSubscriptionError() {
        return this.subscriptionError;
    }

    public Boolean isAttribute(String attributeName) {
        Variant value;
        block3: {
            try {
                value = this.attributes.get(attributeName);
                if (value != null) break block3;
                return null;
            }
            catch (Throwable throwable) {
                return null;
            }
        }
        return value.asBoolean();
    }

    public boolean isAttribute(String attributeName, boolean defaultValue) {
        Boolean value = this.isAttribute(attributeName);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public boolean isManual() {
        return this.isAttribute("manual", false) || this.isAttribute("org.eclipse.scada.da.manual.active", false);
    }

    public boolean isAlarm() {
        return this.isAttribute("alarm", false);
    }

    public boolean isBlocked() {
        return this.isAttribute("blocked", false);
    }

    public boolean isWarning() {
        return this.isAttribute("warning", false);
    }

    public boolean isConnected() {
        return this.subscriptionState == SubscriptionState.CONNECTED;
    }

    public boolean isError() {
        if (this.isConnected()) {
            return this.isAttribute("error", false);
        }
        return false;
    }

    public static Calendar getAsTimestamp(Map<String, Variant> attributes, String attributeName) {
        Variant value = attributes.get(attributeName);
        if (value == null) {
            return null;
        }
        if (!value.isLong()) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        try {
            c.setTimeInMillis(value.asLong());
        }
        catch (Throwable throwable) {
            return null;
        }
        return c;
    }

    public Calendar getAsTimestamp(String attributeName) {
        return DataItemValue.getAsTimestamp(this.attributes, attributeName);
    }

    public boolean getAttributeAsBoolean(String attributeName) {
        Variant value = this.attributes.get(attributeName);
        if (value == null) {
            return false;
        }
        return value.asBoolean();
    }

    public Boolean getAttributeAsBoolean(String attributeName, Boolean defaultValue) {
        Variant value = this.attributes.get(attributeName);
        if (value == null) {
            return defaultValue;
        }
        return value.asBoolean(defaultValue);
    }

    public Calendar getTimestamp() {
        return this.getAsTimestamp("timestamp");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.value != null) {
            sb.append(this.value.toString());
        }
        sb.append("[");
        if (this.isConnected()) {
            sb.append("C");
        }
        if (this.isAlarm()) {
            sb.append("A");
        }
        if (this.isError()) {
            sb.append("E");
        }
        if (this.isManual()) {
            sb.append("M");
        }
        sb.append("]");
        Calendar c = this.getTimestamp();
        if (c != null) {
            sb.append(String.format("[%1$tF %1$tT,%1$tL]", c));
        } else {
            sb.append("[none]");
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        result = 31 * result + (this.subscriptionState == null ? 0 : this.subscriptionState.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataItemValue other = (DataItemValue)obj;
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes)) {
            return false;
        }
        if (this.subscriptionState == null ? other.subscriptionState != null : !this.subscriptionState.equals((Object)other.subscriptionState)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public static class Builder {
        private SubscriptionState subscriptionState;
        private Throwable subscriptionError;
        private Variant value;
        private Map<String, Variant> attributes;

        public Builder() {
            this.value = Variant.NULL;
            this.attributes = new HashMap<String, Variant>();
            this.subscriptionState = SubscriptionState.DISCONNECTED;
        }

        public Builder(DataItemValue sourceValue) {
            if (sourceValue == null) {
                this.value = Variant.NULL;
                this.attributes = new HashMap<String, Variant>();
                this.subscriptionState = SubscriptionState.DISCONNECTED;
            } else {
                this.value = sourceValue.getValue();
                this.attributes = new HashMap<String, Variant>(sourceValue.getAttributes());
                this.subscriptionState = sourceValue.getSubscriptionState();
                this.subscriptionError = sourceValue.getSubscriptionError();
            }
        }

        public SubscriptionState getSubscriptionState() {
            return this.subscriptionState;
        }

        public Builder setSubscriptionState(SubscriptionState subscriptionState) {
            this.subscriptionState = subscriptionState;
            return this;
        }

        public Throwable getSubscriptionError() {
            return this.subscriptionError;
        }

        public Builder setSubscriptionError(Throwable subscriptionError) {
            this.subscriptionError = subscriptionError;
            return this;
        }

        public Variant getValue() {
            return this.value;
        }

        public Builder setValue(Variant value) {
            this.value = value;
            return this;
        }

        public Map<String, Variant> getAttributes() {
            return this.attributes;
        }

        public Builder setAttributes(Map<String, Variant> attributes) {
            this.attributes = attributes;
            return this;
        }

        public Builder setAttribute(String name, Variant value) {
            if (value == null) {
                this.attributes.remove(name);
            } else {
                this.attributes.put(name, value);
            }
            return this;
        }

        public Builder clearAttribute(String name) {
            this.attributes.remove(name);
            return this;
        }

        public Builder setTimestamp(long timestamp) {
            this.setAttribute("timestamp", Variant.valueOf((long)timestamp));
            return this;
        }

        public Builder setTimestamp(Calendar timestamp) {
            if (timestamp == null) {
                this.clearAttribute("timestamp");
            } else {
                this.setAttribute("timestamp", Variant.valueOf((long)timestamp.getTimeInMillis()));
            }
            return this;
        }

        public Calendar getTimestamp() {
            return this.getAsTimestamp("timestamp");
        }

        public Calendar getAsTimestamp(String attributeName) {
            return DataItemValue.getAsTimestamp(this.attributes, attributeName);
        }

        public DataItemValue build() {
            return new DataItemValue(this.value, this.attributes, this.subscriptionState, this.subscriptionError);
        }

        public String toString() {
            return this.build().toString();
        }
    }
}

