/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.storage.postgres;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.VariantEditor;

public class EventConverter {
    private static final String isoDatePatterrn = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss.SSS").serializeNulls().serializeSpecialFloatingPointValues().registerTypeAdapter(Variant.class, (Object)new VariantSerializer()).registerTypeAdapter(Variant.class, (Object)new VariantDeserializer()).create();
    public static final EventConverter INSTANCE = new EventConverter();

    public Event toEvent(String json) {
        return (Event)gson.fromJson(json, Event.class);
    }

    public String toJson(Event event) {
        return gson.toJson((Object)event);
    }

    private static class VariantDeserializer
    implements JsonDeserializer<Variant> {
        private VariantDeserializer() {
        }

        public Variant deserialize(JsonElement jsonElement, Type typeOfDst, JsonDeserializationContext context) throws JsonParseException {
            return VariantEditor.toVariant((String)jsonElement.getAsString());
        }
    }

    private static class VariantSerializer
    implements JsonSerializer<Variant> {
        private VariantSerializer() {
        }

        public JsonElement serialize(Variant src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.toString());
        }
    }
}

