/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.storage.postgres.internal;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.server.storage.BaseStorage;
import org.eclipse.scada.ae.server.storage.Query;
import org.eclipse.scada.ae.server.storage.StoreListener;
import org.eclipse.scada.ae.server.storage.postgres.JdbcDao;
import org.eclipse.scada.ae.server.storage.postgres.NodeIdProvider;
import org.eclipse.scada.ae.server.storage.postgres.internal.CleanUpJob;
import org.eclipse.scada.ae.server.storage.postgres.internal.JdbcQuery;
import org.eclipse.scada.ae.server.storage.postgres.internal.StoreTask;
import org.eclipse.scada.utils.collection.BoundedPriorityQueueSet;
import org.eclipse.scada.utils.filter.Filter;
import org.eclipse.scada.utils.filter.FilterParseException;
import org.eclipse.scada.utils.filter.FilterParser;
import org.eclipse.scada.utils.osgi.jdbc.CommonConnectionAccessor;
import org.eclipse.scada.utils.osgi.jdbc.DataSourceConnectionAccessor;
import org.eclipse.scada.utils.osgi.jdbc.pool.PoolConnectionAccessor;
import org.eclipse.scada.utils.osgi.jdbc.task.CommonConnectionTask;
import org.eclipse.scada.utils.osgi.jdbc.task.ConnectionContext;
import org.eclipse.scada.utils.osgi.jdbc.task.ConnectionTask;
import org.osgi.service.jdbc.DataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcStorage
extends BaseStorage {
    private static final Logger logger = LoggerFactory.getLogger(JdbcStorage.class);
    private final CommonConnectionAccessor accessor;
    private final ScheduledExecutorService scheduler;
    private final ExecutorService dbExecutor;
    private final List<JdbcQuery> openQueries = new CopyOnWriteArrayList<JdbcQuery>();
    private final BoundedPriorityQueueSet<Event> errorQueue = new BoundedPriorityQueueSet(1000);
    private final Queue<StoreTask> storeQueue = new ConcurrentLinkedQueue<StoreTask>();
    private final JdbcDao jdbcDao;
    private ScheduledFuture<?> scheduledProcessStoreQueue;
    private ScheduledFuture<?> scheduledProcessErrorQueue;
    private ScheduledFuture<?> scheduledCleanUpJob;

    public JdbcStorage(DataSourceFactory dataSourceFactory, ScheduledExecutorService scheduler, Properties dbProperties, boolean usePool, String schema, String instance) throws SQLException {
        this.accessor = usePool ? new PoolConnectionAccessor(dataSourceFactory, dbProperties) : new DataSourceConnectionAccessor(dataSourceFactory, dbProperties);
        this.jdbcDao = new JdbcDao(this.accessor, schema, instance, new NodeIdProvider(){

            @Override
            public String getNodeId() {
                return JdbcStorage.this.getNodeId();
            }
        });
        this.scheduler = scheduler;
        this.dbExecutor = Executors.newSingleThreadExecutor();
    }

    public void start() {
        this.scheduledProcessStoreQueue = this.scheduler.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                if (JdbcStorage.this.storeQueue.size() > 0) {
                    try {
                        JdbcStorage.this.processStoreQueue(JdbcStorage.this.getBatchSize());
                    }
                    catch (Exception e) {
                        logger.error("call to processStoreQueue failed", (Throwable)e);
                    }
                }
            }
        }, 1L, 1L, TimeUnit.SECONDS);
        this.scheduledProcessErrorQueue = this.scheduler.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                JdbcStorage.this.processErrorQueue();
            }
        }, 30L, 30L, TimeUnit.SECONDS);
        this.scheduledCleanUpJob = this.scheduler.scheduleWithFixedDelay(new CleanUpJob(this.jdbcDao), CleanUpJob.getCleanupPeriod(), CleanUpJob.getCleanupPeriod(), TimeUnit.SECONDS);
    }

    public void dispose() {
        if (this.scheduledProcessStoreQueue != null) {
            this.scheduledProcessStoreQueue.cancel(false);
        }
        if (this.scheduledProcessErrorQueue != null) {
            this.scheduledProcessErrorQueue.cancel(false);
        }
        if (this.scheduledCleanUpJob != null) {
            this.scheduledCleanUpJob.cancel(false);
        }
        for (JdbcQuery query : this.openQueries) {
            query.dispose();
        }
        this.dbExecutor.shutdownNow();
    }

    public Event store(Event event, StoreListener listener) {
        Event eventToStore = this.createEvent(event);
        if (this.getBatchSize() > 1) {
            this.storeQueue.offer(new StoreTask(listener, eventToStore, true));
        } else {
            this.doStore(Arrays.asList(new StoreTask(listener, eventToStore, true)));
        }
        return eventToStore;
    }

    private Future<Void> doStore(final List<StoreTask> batch) {
        return this.dbExecutor.submit(new Callable<Void>(){

            /*
             * Unable to fully structure code
             */
            @Override
            public Void call() throws Exception {
                block7: {
                    JdbcStorage.access$4().trace("doStore -> Callable started");
                    try {
                        JdbcStorage.access$6(JdbcStorage.this).doWithConnection((ConnectionTask)new CommonConnectionTask<Void>(){

                            public Void performTask(ConnectionContext connectionContext) throws Exception {
                                connectionContext.setAutoCommit(false);
                                for (StoreTask task : batch) {
                                    JdbcStorage.this.jdbcDao.store(connectionContext, task.getEventToStore());
                                    if (!JdbcStorage.this.isReplication()) continue;
                                    JdbcStorage.this.jdbcDao.storeReplication(connectionContext, task.getEventToStore());
                                }
                                connectionContext.commit();
                                return null;
                            }
                        });
                        for (StoreTask task : batch) {
                            if (task.getListener() == null) continue;
                            try {
                                task.getListener().notify(task.getEventToStore());
                            }
                            catch (Exception e) {
                                JdbcStorage.access$4().error("call to listener failed", (Throwable)e);
                            }
                        }
                        break block7;
                    }
                    catch (Exception e) {
                        ** for (task : batch)
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (task.isStoreInErrorQueue()) {
                            JdbcStorage.access$4().error("storing event failed, putting it on error queue", (Throwable)e);
                            JdbcStorage.access$9(JdbcStorage.this).offer((Object)task.getEventToStore());
                            continue;
                        }
                        JdbcStorage.access$4().error("storing event failed", (Throwable)e);
                        continue;
                    }
                }
                JdbcStorage.access$4().trace("doStore -> Callable finished");
                return null;
            }
        });
    }

    public Event update(final UUID id, String comment, final StoreListener listener) throws Exception {
        Future<Event> future = this.dbExecutor.submit(new Callable<Event>(){

            @Override
            public Event call() throws Exception {
                return JdbcStorage.this.jdbcDao.load(id);
            }
        });
        Event event = future.get(10L, TimeUnit.SECONDS);
        final Event eventToStore = Event.create().event(event).attribute(Event.Fields.COMMENT, (Object)comment).build();
        this.dbExecutor.submit(new Callable<Event>(){

            @Override
            public Event call() throws Exception {
                JdbcStorage.this.accessor.doWithConnection((ConnectionTask)new CommonConnectionTask<Void>(){

                    public Void performTask(ConnectionContext connectionContext) throws Exception {
                        connectionContext.setAutoCommit(false);
                        JdbcStorage.this.jdbcDao.update(connectionContext, eventToStore);
                        connectionContext.commit();
                        return null;
                    }
                });
                if (listener != null) {
                    try {
                        listener.notify(eventToStore);
                    }
                    catch (Exception e) {
                        logger.error("call to listener failed", (Throwable)e);
                    }
                }
                return eventToStore;
            }
        });
        return eventToStore;
    }

    private void processStoreQueue(int size) throws InterruptedException, ExecutionException {
        logger.debug("processing store queue, contains approximately {} elements", (Object)this.storeQueue.size());
        ArrayList<StoreTask> batch = new ArrayList<StoreTask>(size);
        int i = 0;
        while (i < size) {
            StoreTask task = this.storeQueue.poll();
            if (task != null) {
                batch.add(task);
            }
            ++i;
        }
        Future<Void> future = this.doStore(batch);
        future.get();
    }

    private void processErrorQueue() {
        logger.debug("processing error queue, contains approximately {} elements", (Object)this.errorQueue.size());
        int size = this.errorQueue.size();
        HashSet<Event> eventsNotSaved = new HashSet<Event>();
        int i = 0;
        while (i < size) {
            Event event = (Event)this.errorQueue.poll();
            if (event == null) break;
            logger.trace("try to store event {} again", (Object)event);
            try {
                Event existingEvent = this.jdbcDao.load(event.getId());
                if (existingEvent != Event.NULL_EVENT) {
                    logger.trace("event {} was already in database", (Object)event.getId());
                } else {
                    Future<Void> future = this.doStore(Arrays.asList(new StoreTask(null, event, false)));
                    future.get();
                }
            }
            catch (Exception exception) {
                logger.trace("storing of event {} failed again", (Object)event);
                eventsNotSaved.add(event);
            }
            ++i;
        }
        for (Event event : eventsNotSaved) {
            this.errorQueue.offer((Object)event);
        }
    }

    public Query query(String filter) throws Exception {
        try {
            Filter parsedFilter = new FilterParser(filter).getFilter();
            return new JdbcQuery(this.jdbcDao, parsedFilter, this.scheduler, this.openQueries);
        }
        catch (FilterParseException e) {
            logger.error("failed to parse filter", (Throwable)e);
            throw e;
        }
    }

    private boolean isReplication() {
        return Boolean.getBoolean("org.eclipse.scada.ae.server.storage.jdbc.enableReplication");
    }

    private int getBatchSize() {
        Integer size = Integer.getInteger("org.eclipse.scada.ae.server.storage.postgres.batchSize", 1);
        return size < 1 ? 1 : size;
    }

    static /* synthetic */ BoundedPriorityQueueSet access$9(JdbcStorage jdbcStorage) {
        return jdbcStorage.errorQueue;
    }
}

