/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common.memory;

import org.apache.mina.core.buffer.IoBuffer;
import org.eclipse.scada.da.server.common.memory.accessor.Getter;
import org.eclipse.scada.da.server.common.memory.accessor.Setter;

public enum ByteOrder {
    LITTLE_ENDIAN{

        @Override
        public <T> T get(IoBuffer data, int index, Getter<T> getter) {
            java.nio.ByteOrder order = data.order();
            try {
                data.order(java.nio.ByteOrder.LITTLE_ENDIAN);
                T t = getter.get(data, index);
                return t;
            }
            finally {
                data.order(order);
            }
        }

        @Override
        public <T> void put(IoBuffer data, Setter<T> setter, T value) {
            java.nio.ByteOrder order = data.order();
            try {
                data.order(java.nio.ByteOrder.LITTLE_ENDIAN);
                setter.put(data, value);
            }
            finally {
                data.order(order);
            }
        }
    }
    ,
    BIG_ENDIAN{

        @Override
        public <T> T get(IoBuffer data, int index, Getter<T> getter) {
            java.nio.ByteOrder order = data.order();
            try {
                data.order(java.nio.ByteOrder.BIG_ENDIAN);
                T t = getter.get(data, index);
                return t;
            }
            finally {
                data.order(order);
            }
        }

        @Override
        public <T> void put(IoBuffer data, Setter<T> setter, T value) {
            java.nio.ByteOrder order = data.order();
            try {
                data.order(java.nio.ByteOrder.BIG_ENDIAN);
                setter.put(data, value);
            }
            finally {
                data.order(order);
            }
        }
    };

    public static ByteOrder DEFAULT;

    static {
        try {
            DEFAULT = ByteOrder.valueOf(System.getProperty("org.eclipse.scada.da.server.common.memory.defaultByteOrder", BIG_ENDIAN.toString()));
        }
        catch (Throwable throwable) {
            DEFAULT = BIG_ENDIAN;
        }
    }

    private ByteOrder() {
    }

    public abstract <T> T get(IoBuffer var1, int var2, Getter<T> var3);

    public abstract <T> void put(IoBuffer var1, Setter<T> var2, T var3);

    /* synthetic */ ByteOrder(String string, int n, ByteOrder byteOrder) {
        this();
    }
}

