/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.server.storage.common;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.eclipse.scada.hd.QueryListener;
import org.eclipse.scada.hd.QueryState;
import org.eclipse.scada.hd.data.QueryParameters;
import org.eclipse.scada.hd.data.ValueInformation;
import org.eclipse.scada.hd.server.storage.common.DataFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QueryDataBuffer {
    public static final String STDDEV = "STDDEV";
    public static final String MAX = "MAX";
    public static final String MIN = "MIN";
    public static final String AVG = "AVG";
    private static final Logger logger = LoggerFactory.getLogger(QueryDataBuffer.class);
    private final QueryListener listener;
    private final Executor executor;
    protected QueryState state;
    private final Date fixedStartDate;
    private final Date fixedEndDate;

    protected abstract Data[] getData();

    public QueryDataBuffer(QueryListener listener, Executor executor, Date fixedStartDate, Date fixedEndDate) {
        this.listener = listener;
        this.executor = executor;
        this.fixedStartDate = fixedStartDate;
        this.fixedEndDate = fixedEndDate;
    }

    protected static void fillDataCells(Data[] data, Calendar start, Calendar end, DataFactory dataFactory) {
        QueryDataBuffer.fillDataCells(data, start.getTimeInMillis(), end.getTimeInMillis(), dataFactory);
    }

    protected static void fillDataCells(Data[] data, long start, long end, DataFactory dataFactory) {
        double period = (double)(end - start) / (double)data.length;
        double counter = 0.0;
        int i = 0;
        while (i < data.length) {
            long startTix = (long)((double)start + counter);
            long endTix = (long)((double)start + (counter + period));
            logger.trace("Init index {} with {} -> {}", new Object[]{i, startTix, endTix});
            data[i] = dataFactory.create(new Date(startTix), new Date(endTix));
            counter += period;
            ++i;
        }
    }

    protected synchronized void notifyParameterUpdate(final QueryParameters parameters, final Set<String> valueTypes) {
        if (this.listener == null) {
            return;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                QueryDataBuffer.this.listener.updateParameters(parameters, valueTypes);
            }
        });
    }

    protected synchronized void notifyData(final int index, final Map<String, List<Double>> values, final List<ValueInformation> valueInformation) {
        if (this.listener == null) {
            return;
        }
        logger.debug("Sending data - index: {}, values#: {}, informations#: {}", new Object[]{index, values.size(), valueInformation.size()});
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                QueryDataBuffer.this.listener.updateData(index, values, valueInformation);
            }
        });
    }

    protected synchronized void notifyStateUpdate(final QueryState state) {
        logger.debug("Change state to {}", (Object)state);
        if (this.state == state) {
            return;
        }
        this.state = state;
        if (this.listener == null) {
            return;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                QueryDataBuffer.this.listener.updateState(state);
            }
        });
    }

    protected void notifyData(int startIndex, int endIndex) {
        int size = endIndex - startIndex;
        ArrayList<ValueInformation> information = new ArrayList<ValueInformation>(size);
        HashMap<String, List<Double>> values = new HashMap<String, List<Double>>(4);
        values.put(AVG, new ArrayList(size));
        values.put(MIN, new ArrayList(size));
        values.put(MAX, new ArrayList(size));
        values.put(STDDEV, new ArrayList(size));
        Data[] data = this.getData();
        int lastIndex = startIndex;
        int i = startIndex;
        while (i < endIndex) {
            if (data[i].isChanged()) {
                data[i].resetChanged();
                if (this.fixedStartDate != null && data[i].getEnd().before(this.fixedStartDate) || this.fixedEndDate != null && data[i].getStart().after(this.fixedEndDate)) {
                    information.add(new ValueInformation(0.0, 0.0, this.convert(data[i].getStart()), this.convert(data[i].getEnd()), 0L));
                    ((List)values.get(AVG)).add(Double.NaN);
                    ((List)values.get(MIN)).add(Double.NaN);
                    ((List)values.get(MAX)).add(Double.NaN);
                    ((List)values.get(STDDEV)).add(Double.NaN);
                } else {
                    double quality = Double.isNaN(data[i].getQuality()) ? 0.0 : data[i].getQuality();
                    double manual = Double.isNaN(data[i].getManual()) ? 0.0 : data[i].getManual();
                    information.add(new ValueInformation(quality, manual, this.convert(data[i].getStart()), this.convert(data[i].getEnd()), data[i].getEntryCount()));
                    ((List)values.get(AVG)).add(data[i].getAverage());
                    ((List)values.get(MIN)).add(data[i].getMin());
                    ((List)values.get(MAX)).add(data[i].getMax());
                    ((List)values.get(STDDEV)).add(data[i].getStdDev());
                }
            } else {
                if (!information.isEmpty()) {
                    this.notifyData(lastIndex, values, information);
                    information.clear();
                    ((List)values.get(AVG)).clear();
                    ((List)values.get(MIN)).clear();
                    ((List)values.get(MAX)).clear();
                    ((List)values.get(STDDEV)).clear();
                }
                lastIndex = i + 1;
            }
            ++i;
        }
        if (!information.isEmpty()) {
            this.notifyData(lastIndex, values, information);
        }
    }

    private long convert(Date date) {
        return date.getTime();
    }

    protected static abstract class Data {
        protected final Date start;
        protected final Date end;
        protected boolean changed;
        private double average = Double.NaN;
        private double quality = Double.NaN;
        private double manual = Double.NaN;
        private double min = Double.NaN;
        private double max = Double.NaN;
        private double stdDev = Double.NaN;

        public Data(Date start, Date end) {
            this.start = start;
            this.end = end;
            this.changed = true;
        }

        public Date getStart() {
            return this.start;
        }

        public Date getEnd() {
            return this.end;
        }

        public boolean isChanged() {
            return this.changed;
        }

        public void resetChanged() {
            this.changed = false;
        }

        public void setAverage(double average) {
            if (Double.compare(this.average, average) != 0) {
                this.changed = true;
                this.average = average;
            }
        }

        public void setStdDev(double stdDev) {
            if (Double.compare(this.stdDev, stdDev) != 0) {
                this.changed = true;
                this.stdDev = stdDev;
            }
        }

        public void setQuality(double error) {
            if (Double.compare(this.quality, error) != 0) {
                this.changed = true;
                this.quality = error;
            }
        }

        public void setManual(double manual) {
            if (Double.compare(this.manual, manual) != 0) {
                this.changed = true;
                this.manual = manual;
            }
        }

        public double getAverage() {
            return this.average;
        }

        public double getStdDev() {
            return this.stdDev;
        }

        public double getQuality() {
            return this.quality;
        }

        public double getManual() {
            return this.manual;
        }

        public void setMax(double max) {
            this.max = max;
        }

        public void setMin(double min) {
            this.min = min;
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }

        public abstract long getEntryCount();

        public void apply(Data data) {
            this.setAverage(data.average);
            this.setManual(data.manual);
            this.setQuality(data.quality);
            this.setMax(data.max);
            this.setMin(data.min);
            this.setStdDev(data.stdDev);
        }
    }
}

