/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.common.event;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.event.EventListener;
import org.eclipse.scada.ae.filter.EventMatcher;
import org.eclipse.scada.ae.server.common.event.EventQuery;
import org.eclipse.scada.utils.collection.BoundedPriorityQueueSet;
import org.eclipse.scada.utils.collection.BoundedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEventQueryImpl
implements EventQuery {
    private static final Logger logger = LoggerFactory.getLogger(AbstractEventQueryImpl.class);
    protected static final int chunkSize = Integer.getInteger("org.eclipse.scada.ae.common.event.pool.chunkSize", 100);
    private final Set<EventListener> listeners = new HashSet<EventListener>();
    protected final Executor executor;
    protected final BoundedQueue<Event> events;

    public AbstractEventQueryImpl(Executor executor, int poolSize) {
        this.executor = executor;
        this.events = new BoundedPriorityQueueSet(poolSize, (Comparator)new Comparator<Event>(){

            @Override
            public int compare(Event o1, Event o2) {
                return Event.comparator.compare(o2, o1);
            }
        });
    }

    protected void notifyEvent(final List<Event> event) {
        final EventListener[] listeners = this.listeners.toArray(new EventListener[this.listeners.size()]);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                EventListener[] eventListenerArray = listeners;
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    EventListener listener = eventListenerArray[n2];
                    listener.handleEvent(event);
                    ++n2;
                }
            }
        });
    }

    @Override
    public synchronized void addListener(final EventListener eventListener) {
        this.listeners.add(eventListener);
        UnmodifiableIterator it = Iterators.partition((Iterator)this.events.iterator(), (int)chunkSize);
        while (it.hasNext()) {
            final List chunk = (List)it.next();
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    eventListener.handleEvent(chunk);
                }
            });
        }
    }

    protected synchronized void addEvents(List<Event> events, EventMatcher matcher) {
        ArrayList<Event> toNotify = new ArrayList<Event>(events.size());
        for (Event event : events) {
            if (matcher != null && !matcher.matches(event) || !this.events.add((Object)event)) continue;
            toNotify.add(event);
        }
        logger.debug("new event pool size: {}", (Object)this.events.size());
        this.notifyEvent(toNotify);
    }

    @Override
    public synchronized void removeListener(EventListener eventListener) {
        this.listeners.remove(eventListener);
    }

    @Override
    public int getCapacity() {
        return this.events.getCapacity();
    }
}

