/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.osgi.modbus;

import java.nio.ByteOrder;
import org.eclipse.scada.da.server.osgi.modbus.RequestType;

public class Request {
    private final int startAddress;
    private final int count;
    private final long period;
    private final String mainTypeName;
    private final long timeout;
    private final RequestType type;
    private final boolean eager;
    private final ByteOrder dataOrder;

    public Request(RequestType type, int startAddress, int count, long period, long timeout, String mainTypeName, boolean eager, ByteOrder dataOrder) {
        this.type = type;
        this.startAddress = startAddress;
        this.count = count;
        this.period = period;
        this.timeout = timeout;
        this.mainTypeName = mainTypeName;
        this.eager = eager;
        this.dataOrder = dataOrder;
    }

    public boolean isEager() {
        return this.eager;
    }

    public String getMainTypeName() {
        return this.mainTypeName;
    }

    public long getPeriod() {
        return this.period;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public int getStartAddress() {
        return this.startAddress;
    }

    public int getCount() {
        return this.count;
    }

    public RequestType getType() {
        return this.type;
    }

    public ByteOrder getDataOrder() {
        return this.dataOrder;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.count;
        result = 31 * result + (this.dataOrder == null ? 0 : this.dataOrder.hashCode());
        result = 31 * result + (this.eager ? 1231 : 1237);
        result = 31 * result + (this.mainTypeName == null ? 0 : this.mainTypeName.hashCode());
        result = 31 * result + (int)(this.period ^ this.period >>> 32);
        result = 31 * result + this.startAddress;
        result = 31 * result + (int)(this.timeout ^ this.timeout >>> 32);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Request)) {
            return false;
        }
        Request other = (Request)obj;
        if (this.count != other.count) {
            return false;
        }
        if (this.dataOrder == null ? other.dataOrder != null : !this.dataOrder.equals(other.dataOrder)) {
            return false;
        }
        if (this.eager != other.eager) {
            return false;
        }
        if (this.mainTypeName == null ? other.mainTypeName != null : !this.mainTypeName.equals(other.mainTypeName)) {
            return false;
        }
        if (this.period != other.period) {
            return false;
        }
        if (this.startAddress != other.startAddress) {
            return false;
        }
        if (this.timeout != other.timeout) {
            return false;
        }
        return this.type == other.type;
    }

    public String toString() {
        return String.format("[Request - type: %s, start: %s, count: %s, period: %s, timeout: %s, mainType: %s, eager: %s, dataOrder: %s]", new Object[]{this.type, this.startAddress, this.count, this.period, this.timeout, this.mainTypeName, this.eager, this.dataOrder});
    }
}

