/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.server.common.stats;

import java.lang.management.ManagementFactory;
import java.net.SocketAddress;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.eclipse.scada.core.server.common.stats.ManagedConnectionMXBean;
import org.eclipse.scada.core.server.common.stats.StatisticInformation;
import org.eclipse.scada.utils.stats.StatisticEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ManagedConnection
implements ManagedConnectionMXBean {
    private static final Logger logger = LoggerFactory.getLogger(ManagedConnection.class);
    private ObjectName name;

    public void setName(ObjectName name) {
        this.name = name;
    }

    public void dispose() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.unregisterMBean(this.name);
        }
        catch (Exception e) {
            logger.warn("Failed to unregister MXBean", (Throwable)e);
        }
    }

    @Override
    public StatisticInformation[] getStatistics() {
        ArrayList<StatisticInformation> result = new ArrayList<StatisticInformation>();
        for (StatisticEntry entry : this.getEntries()) {
            if (entry.getValue() == null) continue;
            result.add(new StatisticInformation(entry.getLabel(), this.makeDouble(entry.getValue().getCurrent()), this.makeDouble(entry.getValue().getMinimum()), this.makeDouble(entry.getValue().getMaximum())));
        }
        return result.toArray(new StatisticInformation[result.size()]);
    }

    private Double makeDouble(Number number) {
        if (number == null) {
            return null;
        }
        return number.doubleValue();
    }

    protected abstract Collection<StatisticEntry> getEntries();

    public static ManagedConnection register(ManagedConnection connection, SocketAddress socketAddress, String baseName) {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            logger.debug("Creating name for: {}", (Object)socketAddress);
            String remote = URLEncoder.encode(socketAddress.toString(), "UTF-8");
            ObjectName name = new ObjectName(baseName, "remote", remote);
            connection.setName(name);
            mbs.registerMBean(connection, name);
            return connection;
        }
        catch (Exception e) {
            logger.warn("Failed to register MXBean", (Throwable)e);
            return null;
        }
    }
}

