/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.server.storage.hds;

import java.io.File;
import java.io.FileInputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.scada.hd.Query;
import org.eclipse.scada.hd.QueryListener;
import org.eclipse.scada.hd.data.HistoricalItemInformation;
import org.eclipse.scada.hd.data.QueryParameters;
import org.eclipse.scada.hd.server.common.HistoricalItem;
import org.eclipse.scada.hd.server.storage.common.QueryImpl;
import org.eclipse.scada.hd.server.storage.common.ValueSourceManager;
import org.eclipse.scada.hd.server.storage.hds.StorageConfiguration;
import org.eclipse.scada.hd.server.storage.hds.StorageInformation;
import org.eclipse.scada.hds.DataFilePool;
import org.eclipse.scada.hds.DataStoreAccesor;
import org.eclipse.scada.hds.DataStoreListener;
import org.eclipse.scada.hds.ValueVisitor;
import org.eclipse.scada.utils.concurrent.FutureTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStorageImpl
implements HistoricalItem,
ValueSourceManager {
    private static final Logger logger = LoggerFactory.getLogger(AbstractStorageImpl.class);
    private final File file;
    protected final String id;
    protected final DataStoreAccesor nativeLevel;
    protected final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    protected final Lock writeLock = this.rwLock.writeLock();
    protected final Lock readLock = this.rwLock.readLock();
    private boolean disposed;
    private final ScheduledExecutorService queryExecutor;
    private final Set<QueryImpl> queries = new HashSet<QueryImpl>();
    private final Set<Future<?>> jobs = new CopyOnWriteArraySet();
    private final Lock jobLock = new ReentrantLock();
    private final Condition jobCondition = this.jobLock.newCondition();
    private final ScheduledExecutorService eventExecutor;

    public AbstractStorageImpl(File file, DataFilePool pool, ScheduledExecutorService queryExecutor, ScheduledExecutorService eventExecutor) throws Exception {
        this.file = file;
        this.queryExecutor = queryExecutor;
        this.eventExecutor = eventExecutor;
        Properties p = new Properties();
        p.loadFromXML(new FileInputStream(new File(file, "settings.xml")));
        this.id = p.getProperty("id");
        this.nativeLevel = new DataStoreAccesor(new File(file, "native"), pool);
        this.nativeLevel.addListener(new DataStoreListener(){

            public void storeChanged(Date start, Date end) {
                AbstractStorageImpl.this.handleStoreChanged(start, end);
            }
        });
    }

    protected void addJob(FutureTask<Void> task) {
        this.jobs.add((Future<?>)task);
    }

    protected void removeJob(Future<Void> future) {
        this.jobLock.lock();
        try {
            this.jobs.remove(future);
            this.jobCondition.signalAll();
        }
        finally {
            this.jobLock.unlock();
        }
    }

    public StorageInformation getStorageInformation() {
        StorageConfiguration configuration = new StorageConfiguration(this.nativeLevel.getTimeSlice(), this.nativeLevel.getCount());
        StorageInformation information = new StorageInformation(this.id, this.file, configuration);
        return information;
    }

    public HistoricalItemInformation getInformation() {
        HashMap properties = new HashMap(0);
        HistoricalItemInformation info = new HistoricalItemInformation(this.id, properties);
        return info;
    }

    protected void runOnQuery(QueryRunnable runnable) {
        this.readLock.lock();
        try {
            for (QueryImpl query : this.queries) {
                try {
                    runnable.run(query);
                }
                catch (Exception e) {
                    logger.warn("Failed to run query update", (Throwable)e);
                }
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected void handleStoreChanged(final Date start, final Date end) {
        this.runOnQuery(new QueryRunnable(){

            @Override
            public void run(final QueryImpl query) throws Exception {
                if (query.isUpdateData()) {
                    AbstractStorageImpl.this.queryExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            query.dataChanged(start, end);
                        }
                    });
                }
            }
        });
    }

    protected void notifyData(final double value, final Date timestamp, final boolean error, final boolean manual) {
        this.runOnQuery(new QueryRunnable(){

            @Override
            public void run(final QueryImpl query) throws Exception {
                if (query.isUpdateData()) {
                    AbstractStorageImpl.this.queryExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            query.updateData(value, timestamp, error, manual);
                        }
                    });
                }
            }
        });
    }

    public Query createQuery(QueryParameters parameters, QueryListener listener, boolean updateData) {
        this.writeLock.lock();
        try {
            if (this.disposed) {
                logger.warn("Unable to create query. We are disposed");
                return null;
            }
            QueryImpl query = new QueryImpl((ValueSourceManager)this, this.queryExecutor, this.eventExecutor, parameters, listener, updateData, null, null);
            this.queries.add(query);
            QueryImpl queryImpl = query;
            return queryImpl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void queryClosed(QueryImpl query) {
        this.writeLock.lock();
        try {
            this.queries.remove(query);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean visit(QueryParameters parameters, ValueVisitor visitor) {
        logger.debug("Visiting - parameters: {}", (Object)parameters);
        return this.nativeLevel.visit(visitor, new Date(parameters.getStartTimestamp()), new Date(parameters.getEndTimestamp()));
    }

    public void dispose() {
        this.writeLock.lock();
        try {
            this.disposed = true;
        }
        finally {
            this.writeLock.unlock();
        }
        this.jobLock.lock();
        try {
            HashSet<QueryImpl> queries = new HashSet<QueryImpl>(this.queries);
            for (QueryImpl query : queries) {
                query.close();
            }
            this.queries.clear();
            while (!this.jobs.isEmpty()) {
                try {
                    this.jobCondition.await();
                }
                catch (InterruptedException e) {
                    logger.warn("Failed to wait for update jobs", (Throwable)e);
                    Thread.interrupted();
                    break;
                }
            }
            this.nativeLevel.dispose();
        }
        finally {
            this.jobLock.unlock();
        }
    }

    protected static interface QueryRunnable {
        public void run(QueryImpl var1) throws Exception;
    }
}

