/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.server.storage.master.hds.console;

import java.io.File;
import org.apache.felix.service.command.Descriptor;
import org.eclipse.scada.hd.server.storage.hds.StorageConfiguration;
import org.eclipse.scada.hd.server.storage.hds.StorageInformation;
import org.eclipse.scada.hd.server.storage.master.hds.StorageManager;

public class Console {
    private final StorageManager manager;

    public Console(StorageManager manager) {
        this.manager = manager;
    }

    @Descriptor(value="Delete all data outside of the valid time spec")
    public void purgeAll() {
        System.out.print("Purging...");
        System.out.flush();
        this.manager.purgeAll();
        System.out.println("done!");
    }

    @Descriptor(value="List all HDS storages")
    public void list() {
        System.out.println("ID\t\tLocation");
        System.out.println("============================================");
        for (StorageInformation info : this.manager.list()) {
            this.printStorage(info);
        }
        System.out.println("============================================");
    }

    private void printStorage(StorageInformation info) {
        System.out.println(String.format("%s\t\t%s", info.getId(), info.getFile()));
        StorageConfiguration cfg = info.getConfiguration();
        System.out.println(String.format("\t\tnative: %s ms, %s", cfg.getTimeSlice(), cfg.getCount()));
    }

    @Descriptor(value="Create a new HDS storage")
    public void create(@Descriptor(value="the new id") String id, @Descriptor(value="number of milliseconds each file is valid for") long time, @Descriptor(value="the number of files to keep") int count) throws Exception {
        this.manager.addStorage(id, time, count);
    }

    @Descriptor(value="Remove storage by id")
    public void remove(String[] args) {
        if (args.length <= 0) {
            System.out.println("Usage: remove [--force] id1 [id2 [id3]]");
            return;
        }
        boolean force = false;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if ("--force".equals(id)) {
                force = true;
            } else {
                System.out.println(String.format("Removing storage '%s' ...", id));
                System.out.flush();
                this.removeById(id, force);
                System.out.println(String.format("Removing storage '%s' ... done!", id));
            }
            ++n2;
        }
    }

    private void removeById(String id, boolean force) {
        for (StorageInformation info : this.manager.list()) {
            if (!id.equals(info.getId())) continue;
            System.out.println(String.format("Removing file - id: %s, file: %s, force: %s", id, info.getFile(), force));
            this.removeByFile(info.getFile(), force);
        }
    }

    private void removeByFile(File file, boolean force) {
        try {
            this.manager.removeStorage(file, force);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

